


/** 

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.



@author Nikos Katsikanis <nkatsikanis@hotmail.com>
@version 1.4 18/07/06

This is the main class of the plugin
This Class mostly my own work except that it 
uses Nico Stuurman's <nicos@itsa.ucsf.edu> stack runthrough algorithim(modifed by myself) 
His methods that I modified where the method named processStacks and mergeStacks.
Also I modifed the class called RGB_Gray_Merge.java (writen by C. Laummonerie & J. Mutterer (many thanks)
Email    : jerome.mutterer at ibmp-ulp.u-strasbg.fr.
I used their class to add to the functionality of my plugin.

This plugin allows split Images by the Cairn Optosplit devices to be analysed. 
This plugin does this by use of Nudging overlayed RGB images and looking at RGB_Pofiles in order
to align the split images. Each separated image can then be saved seperately. Multiple
alignment settings can be saved.

Requirements   ImageJ 1.3 and above

Improvements in previous versions

	Version 1.2
				*RGB profiler added 

	Version 1.21

				*RGB profiler improved
				*all contents packaged inside a jar
			
     Version (1.3)

				*GUI improved
				*added RGB profile position to be changed by mouse
				*fixed a bug that incremented the ROI even though image out of bounds fixed
				*fixed a bug that stopped refreshing the blue RGB profiler
			
     Version (1.4)	
	
				*Fixed a bug that caused only 2 images to open when a 3 way
				*alignment file was used, in open last alignment function
				*Added batch processing of images with alignment settings
		
	improvements this Version (1.5)	
	
				*added channel intensity equalisation
	
*/


import ij.*;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.io.FileSaver;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import ij.io.Opener;
import ij.process.*;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.imageio.ImageIO;
import javax.swing.*;
import javax.swing.border.*;

import sun.net.www.content.text.plain;


import java.io.*;
import java.net.*;
//import javax.swing.filechooser.*;

import ij.plugin.*;
import ij.plugin.frame.PlugInFrame;
//import ij.plugin.frame.PlugInFrame;

public class Cairn_Image_Splitter implements PlugIn,ActionListener,ItemListener {

	private static String[] choices = {"Tiff", "8-bit Tiff", "Zip", "Raw"};
	private static String format = "Tiff";
	//used to find current directory of program so as to open images in jar file
	 static final int SEGMENTED = 22;
	 static final int SUBTRACTION = 23;
	 static final String currDir = System.getProperty("user.dir") + File.separator;
	 static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize(); 
	 static final int NO_IMAGE_CROPPED = 0;
	 static final int ONE_IMAGE_CROPPED = 1;
	 static final int TWO_IMAGES_CROPPED = 2;
	 static final int NORTH = 0;
	 static final int EAST = 1;
	 static final int SOUTH = 2;
	 static final int WEST = 3;
	 //used in setting window locations
	 static final int SPLITS_FROM_BOTTOM = 25;
	 static final int OPEN_ALIGNMENT_PROGRAM_STATE = 1;
	 static final int DEFULT_PROGRAM_STATE = 0;
	
	 
	//these variables are used to refer to windows that are open for modification
	ImagePlus originalImage;
	int firstImageID;
	int leftImageID;
	int rightImageID;
	int thirdImageID;
	int horizontal_profileID;
	int vertical_profileID;
	
	int rgbID;
	int stackrgbID;
	
	int RGBmode;
	int programState = DEFULT_PROGRAM_STATE;
	//data for each image that the batch processing uses
	ImagePlus[] batchImages = new ImagePlus[4];	//holds three images + 1 rgb image
	ImagePlus Bimg;  //used to store current image in the batch file
	//main GUI panel
	 JFrame main_Plugin_Window;
	 //menu bar at top
	 
	 JMenuBar mb;
	 JMenu help;
	 //JMenuItem about;
	 
	
	 JPanel utilityPanel ,extraPanel,directionPanel,groupPanel,RGBoptions ,subtractOptions,nudgeOptions,numberOfSplitsPanel; // panels
	
	 JFileChooser fc;		//for open and save purposes
	 JFileChooser openAlignfc;		//for open and save purposes
	 
	 RGBprofiler rgbProfiler;
	
	 
	 JButton copyButton, resetButton, OKButton, saveButton, saveBatchButton, openButton, openLastButton, initialiseButton;
	
	 JButton northButton,northButton10, eastButton,eastButton10, southButton,southButton10, westButton, westButton10;  //nudge buttons
	 JButton cairnButton, batch;
	 
	 JLabel color, profilerLabel;		//for labeling only, no functionality provided with these
		
	 JRadioButton redRB, greenRB, blueRB, _1_and_2, _1_and_3;
	 JCheckBox redC, greenC, blueC, profilerC; 
	 
	 ButtonGroup group;
	
	 JRadioButton TwoSplitButton,ThreeSplitButton;	 //used to tell computer how many split images there are 
	
	 
	 JTextArea instructions;
	 JRadioButtonMenuItem segmentedColorChannels, channelSubtraction;
	 JCheckBoxMenuItem BatchSave1st, BatchSave2nd, BatchSave3rd, BatchSaveRGB,channelIntensityEqualisation;
	 //
	ImageIcon cairnIcon, northIcon, northIcon10, eastIcon, eastIcon10, southIcon, southIcon10, westIcon, westIcon10, redIcon,
	 greenIcon, blueIcon, greyIcon, showgraph,align, optosplit,optoDiagram;
	 
	Rectangle r1;					// these are very important as they let the program know where to split the stack and can be saved to be used with other stacks.
	Rectangle r2;
	Rectangle r3;					//only ever used if a three way image spliter was used to collect the images
	
	 int copyCount;
	 
	 //when processStacks is called this lets it know if the two images are aligned
	 //is so it will process the whole stack with the alignment value
	boolean twoAligned;
	

	boolean threeAligned;			//only for triple split when processStacks is called this lets it know if the three images are aligned is so it will process the whole stack with the alignment value
	boolean isForProcessBatch;  	// are the process stacks methods being called for batch analysis purposes
		
	boolean isRGBOptionsActivated;  // is the rgb panel ready to be used
	
	boolean showRedStack;			//booleans that let the mergestack now what color channels to display
	boolean showGreenStack;
	boolean showBlueStack;
	
	boolean nudgeRedStack;			//lets the program know what channel to nudge after the initial images are overlapped
	boolean nudgeGreenStack;		//lets the program know what channel to nudge after the initial images are overlapped
	boolean nudgeBlueStack;			//lets the program know what channel to nudge after the initial images are overlapped
	
	boolean hasFirstRGBbeenShown;	// this tells us wether are RGB combined image has been draw yet important because we have to get the imageProcessor from it and the comipiler would through a null pointer exception is one hadn't already been created
	boolean profilerActivated;		//it this required at the moment
	boolean isTwoSplit;				//let the program know what type of image splitter is used
	boolean isThreeSplit;			//let the program know what type of image splitter is used
	boolean errorFound; 			//monitors wether an error has occured
	boolean artDataFailed;
	boolean isFirstRun;  			//is this first time programe has run
	boolean stopChannelIntensityEqualisation;
	
	boolean likesProfiler;			//does the user use RGBProfiler, will remember and display later if user has used it before in the current program run
	
	
	
	public void run(String arg) {
		getArtData();
		isFirstProgramRun();
		originalImage=WindowManager.getCurrentImage();
		if (originalImage==null) {
			JOptionPane.showMessageDialog(main_Plugin_Window,"No image open!");
			
			return;
		}
		
		//JFrame.setDefaultLookAndFeelDecorated(true);
		firstImageID = originalImage.getID();
		copyCount = -1;
	//	programState = NO_COPY
		twoAligned = false;
		hasFirstRGBbeenShown = false;
		errorFound = false;
		//overall main panel
		
		setUpGUI();
		initialGUILayout(); //do this stuff elsewhere to keep things tidy an provide flexability
		
		addActionListeners();
		defultButtonSettings();
		initialiseVariables();
		testSplitMode();
		
		//main_Plugin_Window.setResizable(false);
		main_Plugin_Window.pack();
		main_Plugin_Window.setVisible(true);
		//if(main_Plugin_Window.isDefaultLookAndFeelDecorated())  some imageJ versions don't support this command
		//	System.out.println("sds");
		int x = instructions.getWidth();
		int y = instructions.getHeight();
		Dimension d2 = new Dimension(x+20,y);
		instructions.setSize(d2);
		instructions.setPreferredSize(d2);
		if(isFirstRun){
			setHasRunBefore();
		}
		
	}

	
	public void setUpGUI(){
		main_Plugin_Window = new JFrame("Cairn Image Splitter Analyser");
		main_Plugin_Window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		 mb = new JMenuBar();
		
		 
		 
		 JMenu advanced =  new JMenu("Advanced");  //a new menu
		 
		 JMenu rgbMode =  new JMenu("RGB mode");
		 segmentedColorChannels =  new JRadioButtonMenuItem("Segmented color channels");  //control the mode for the channel subtraction 
		 segmentedColorChannels.addActionListener(new ActionListener(){ 
			 public void actionPerformed(ActionEvent e){
				 RGBmode = SEGMENTED;
				 if(copyCount == 1){
					 radioButton_and_profiler_Methods();
					 enableRGBPanel();
				 }
				 if(copyCount == 2 ){
					 radioButton_and_profiler_Methods();
					 enableRGBPanel();
				 }
				 _1_and_2.setEnabled(false);
				 _1_and_3.setEnabled(false);
			 }
		 });
		 channelSubtraction =  new JRadioButtonMenuItem("Channel subtraction");
		 channelSubtraction.addActionListener(new ActionListener(){
			 public void actionPerformed(ActionEvent e){
				 RGBmode = SUBTRACTION;
				 if(copyCount > 0){  //don't want panel activating early
					 _1_and_2.setEnabled(true);
					 _1_and_3.setEnabled(false);
				 }
				 if(copyCount == 1){
					 radioButton_and_profiler_Methods();
					 enableRGBPanel();
					
				 }  
				 if(copyCount == 2 ){
					 if(greenRB.isSelected()){  //just to keep things tidy after changing mode
						 _1_and_2.setSelected(true);
						 if(programState != OPEN_ALIGNMENT_PROGRAM_STATE && copyCount > 0){
								nudgeRedStack = false;
								nudgeGreenStack = true;
								nudgeBlueStack = false;
							 radioButton_and_profiler_Methods();
						 	 
						 }
					 }
					 radioButton_and_profiler_Methods();
					 enableRGBPanel();
					 _1_and_2.setEnabled(true);
					 _1_and_3.setEnabled(true);
				 }
			 }
		 });
		 ButtonGroup group = new ButtonGroup();
		 group.add(segmentedColorChannels);
		 group.add(channelSubtraction);
		 rgbMode.add(segmentedColorChannels);
		 rgbMode.add(channelSubtraction);
		 segmentedColorChannels.setSelected(true);
		 
		 channelIntensityEqualisation = new  JCheckBoxMenuItem("Channel intensity equalisation");
		 
		 
		 
		 ///////////*********************************************
		 
		 
		 
		 
		 
		 
		 advanced.add(rgbMode);
		 advanced.add(channelIntensityEqualisation);
		 advanced.addSeparator();
		 
		 BatchSave1st =  new  JCheckBoxMenuItem("Batch Save 1st channel");  //what images are saved in batch processing
		 BatchSave2nd =  new  JCheckBoxMenuItem("Batch Save 2nd channel");
		 BatchSave3rd =  new  JCheckBoxMenuItem("Batch Save 3rd channel");
		 BatchSaveRGB =  new  JCheckBoxMenuItem("Batch Save RGB channel");
		
		 advanced.add(BatchSave1st);
		 advanced.add(BatchSave2nd);
		 advanced.add(BatchSave3rd);
		 advanced.add(BatchSaveRGB);
		 mb.add(advanced);
		 help = new JMenu("Help");
		 
	
	 

		 JMenuItem channelIntensityEqualisationText = new JMenuItem("Channel intensity equalisation");
		 help.add(channelIntensityEqualisationText);
		 channelIntensityEqualisationText.addActionListener(new ActionListener(){
			 public void actionPerformed(ActionEvent e){
				 String equalisationHelpText = "Channel intensity equalisation allows easy alignment\n" +
			 	   "of images of differing intensities\n"+
			 	   "This works by multiplying the intensitiy of the images to\n"+
			 	   "make each as bright as each other\n\n"+
			 	   "Using this feature does not effect the final images, it is only used \n"+
			 	   "to aid alignment\n";
				JOptionPane.showMessageDialog(main_Plugin_Window,equalisationHelpText);
			 }
		 });


		 JMenuItem batchProcessing = new JMenuItem("Batch Wizard");
		 help.add(batchProcessing);
		 batchProcessing.addActionListener(new ActionListener(){
			 public void actionPerformed(ActionEvent e){
				 String batchHelpText = "The procedure for batch processing is as follows \n" +
				   "Setup: \n"+
				   "a) Create a folder and place all your images (of the same size) to be processed inside this\n"+
				   "b) Create another folder for your split images to go to\n\n"+
				   " Then:\n"+
				   "i) Select what images you want to be output in the Advanced menu\n"+
			 	   "ii) Select a source directory where the images to be processed are\n"+
			 	   "iii) Select the destination directory for the split images\n"+
			 	   "iv) Select the alignment file\n\n"+
			 	   "After you have done this the program will iterate through the source directory\n"+
			 	   "outputing images for channel 1, channel 2, channel 3, and RGB according to your batch settings\n"+
			 	   "The batch settings under Advanced set what images are outputed for each image in the source directory\n"+
			 	   "If however the alignment file was made with OptoSplit II mode, no image will be made for channel 3\n"+ 
			 	   "whether it is selected or not in the Advanced menu\n\n"+
			 	   "Note: it is important that all the images in the source directory are the same size as the \n"+
			 	   "image used to make the alignment file\n"+
			 	   "If there are many images in the source directory, this may take some time"; 
			 
 
				JOptionPane.showMessageDialog(main_Plugin_Window,batchHelpText);
			 }
		 });
		 JMenuItem about = new JMenuItem("About");
		 help.addSeparator();
		 help.add(about);
		 about.addActionListener(new ActionListener(){
			 public void actionPerformed(ActionEvent e){
				 String aboutText = "Cairn Image Splitter Analyser 1.5\n"+ 
					"Author: Nikos Katsikanis\n"+
					"nkatsikanis@hotmail.com\n"+
					"Java 1.5.0_04\n\n"+
					"Comments and feedback are most welcome";
				JOptionPane.showMessageDialog(main_Plugin_Window,aboutText,"About this plugin",JOptionPane.INFORMATION_MESSAGE,optosplit);
			 }
		 });
		
		 main_Plugin_Window.setJMenuBar(mb);
		 mb.add(help);
		
		 batch = new JButton("Batch Wizard");
		 batch.addActionListener(new ActionListener(){
			 public void actionPerformed(ActionEvent e){
				 start_Batch_Analyser();
				 //test_start_Batch_Analyser();
			 }
		 });
		 
		 
		
		//main_Plugin_Window.setResizable(false);
		//panel holding Utility buttons
	    utilityPanel = new JPanel();
		utilityPanel.setLayout(new GridLayout(5,2));
		copyButton = new JButton(" Select 1st Channel ");
		resetButton = new JButton("Reset");
		initialiseButton = new JButton("Initialise");	
		//checkAlignmentButton = new JButton("Check Alignment");
		OKButton = new JButton("OK");
		
		//add on buttons, buttons that were put in later in development
		
	
		fc = new JFileChooser();
		openAlignfc = new JFileChooser();
		openAlignfc.setFileFilter(new AlignmentFilter());		//filter for alignment files
		openAlignfc.setAcceptAllFileFilterUsed(false);			//dont want all files option
		openAlignfc.setFileView(new AlignmentFileView(align));
		
		saveButton = new JButton("Save Current Alignment");
		saveBatchButton = new JButton("Use Last Alignment to process batch");
		openButton = new JButton("Open Alignment");
		openLastButton = new JButton("Open Last Alignment");
		
		//ImageIcon cairnIcon = new ImageIcon("C:/Program Files/ImageJ/plugins/Color/cairn.jpeg",
        //"cairn");
        //cairnLabel = new JLabel( cairnIcon, JLabel.CENTER);
		Border blackline = BorderFactory.createLineBorder(Color.black);

        instructions = new JTextArea(" Welcome to the Image Splitter plugin \n \n" +
        " Please select either OptoSplit II or TripleSplit\n"+
        " Then draw a rectangular box around your first sub image \n"+
        " Now press Select 1st Channel \n\n" +
    	" After you press Select 1st Channel the program will refer to your current image \n"+
    	" To work with a different image, select its window and press initialise");
		instructions.setBorder(blackline);
	
		instructions.setEditable(false);
		utilityPanel.add(copyButton);
		utilityPanel.add(OKButton);
		utilityPanel.add(saveButton);
		//utilityPanel.add(saveBatchButton);
		utilityPanel.add(openButton);
		utilityPanel.add(openLastButton);
		utilityPanel.add(batch);
		utilityPanel.add(resetButton);
		utilityPanel.add(initialiseButton);

		
	
		
	
		
//		initialise all the compnents with art here if load succesful
		if(!artDataFailed){
			northButton = new JButton(northIcon);
			northButton10 = new JButton(northIcon10);
			eastButton = new JButton(eastIcon);
			eastButton10 = new JButton(eastIcon10);
			southButton = new JButton(southIcon);
			southButton10 = new JButton(southIcon10);
			westButton = new JButton(westIcon);
			westButton10 = new JButton(westIcon10);
			profilerLabel = new JLabel(showgraph);
		}
		//Direction Panel for small movements
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		directionPanel = new JPanel(gridbag);

		
		c.weightx = 1.0;
		c.gridx = 2;
		c.gridy = 0;
		c.gridwidth = 2;
		c.gridheight = 1;
		directionPanel.add(northButton10, c);
		
		c.gridy = 1;
		directionPanel.add(northButton, c);
		
		c.gridy = 4;
		directionPanel.add(southButton, c);
		
		c.gridy = 5;
		directionPanel.add(southButton10, c);
		
		c.gridx = 2;
		c.gridy = 2;
		c.gridwidth = 2;
		c.gridheight = 2;
		if(color != null){
			directionPanel.add(color, c);
		}
		
		c.gridx = 4;
		c.gridy = 2;
		c.gridwidth = 1;
		c.gridheight = 2;
		directionPanel.add(eastButton, c);
		
		c.gridx = 5;
		
		directionPanel.add(eastButton10, c);
		
		c.gridx = 0;
		directionPanel.add(westButton10, c);
		
		c.gridx = 1;
		directionPanel.add(westButton, c);
		
		
			//redRB = new JRadioButton(redRBIcon);
			//greenRB = new JRadioButton(greenRBIcon);
			//blueRB = new JRadioButton(blueRBIcon);
//			 use this for now untill radio button works prop
	      	 redRB = new JRadioButton("Red");
	      	  greenRB = new JRadioButton("Green");
	      	  blueRB = new JRadioButton("Blue");
		
	
		
		if(color!=null){
		//directionPanel.add(color, BorderLayout.CENTER);
		}
		nudgeOptions = new JPanel(new GridLayout(1,2));
//		panel that has the options for nudging and displaying different channels
		RGBoptions = new JPanel();
		Border empty = new EmptyBorder(0, 10, 0, 0);
		Border titled = BorderFactory.createTitledBorder(blackline, "RGB options",TitledBorder.CENTER,TitledBorder.ABOVE_TOP);
		RGBoptions.setBorder(BorderFactory.createCompoundBorder( empty,titled));
		RGBoptions.setLayout(new GridLayout(5, 2));
		//text on the GUI
		JLabel nudgeChannel = new JLabel("Nudge ");
		JLabel display = new JLabel("Display");
		
		
		//sets up the radio button group;
		group = new ButtonGroup();
	    group.add(redRB);
	    group.add(greenRB);
	    group.add(blueRB);
	    RGBoptions.add(nudgeChannel);
	    RGBoptions.add(display);
	    
	    
	    redC = new JCheckBox();
	    redC.setSelected(true);
	    greenC = new JCheckBox();
	    greenC.setSelected(true);
	    blueC = new JCheckBox();
	    blueC.setSelected(true);
	    profilerC = new JCheckBox();
	    profilerC.setSelected(false);
	    
		RGBoptions.add(redRB);
		RGBoptions.add(redC);
		RGBoptions.add(greenRB);
		RGBoptions.add(greenC);
		RGBoptions.add(blueRB);
		RGBoptions.add(blueC);
		RGBoptions.add(profilerLabel);
		RGBoptions.add(profilerC);
		nudgeOptions.add(RGBoptions);
		
		subtractOptions = new JPanel(new GridLayout(2,1));
		ButtonGroup groupSub = new ButtonGroup();
		_1_and_2 = new JRadioButton("Channel 1 & 2");
		_1_and_2.addActionListener(new ActionListener(){ 
			 public void actionPerformed(ActionEvent e){
				 if(programState != OPEN_ALIGNMENT_PROGRAM_STATE && copyCount > 0){
						nudgeRedStack = false;
						nudgeGreenStack = true;
						nudgeBlueStack = false;
						if(color!=null){
							setColorGreen();
						}
					 radioButton_and_profiler_Methods();
					 if(!redRB.isSelected()){
						 greenRB.setSelected(true);
					 }
				 }
			 }
		 });
		_1_and_3 = new JRadioButton("Channel 1 & 3");
		_1_and_3.addActionListener(new ActionListener(){ 
			 public void actionPerformed(ActionEvent e){
				 if(programState != OPEN_ALIGNMENT_PROGRAM_STATE && copyCount > 0){
					 nudgeRedStack = false;
						nudgeGreenStack = false;
						nudgeBlueStack = true;
						if(color!=null){
							setColorBlue();
						}
					 radioButton_and_profiler_Methods();
					 if(!redRB.isSelected()){
						 blueRB.setSelected(true);
					 }
				 }
			 }
		 });
		subtractOptions.add(_1_and_2);
		subtractOptions.add(_1_and_3);
		Border titled2 = BorderFactory.createTitledBorder(blackline, "Subtraction options",TitledBorder.CENTER,TitledBorder.ABOVE_TOP);
		subtractOptions.setBorder(BorderFactory.createCompoundBorder( empty,titled2));
		
		groupSub.add( _1_and_2);
		groupSub.add( _1_and_3);
		nudgeOptions.add(subtractOptions);
		
		numberOfSplitsPanel = new JPanel();
		numberOfSplitsPanel.setLayout(new GridLayout(5,1));
		TwoSplitButton = new JRadioButton("OptoSplit II");
		ThreeSplitButton = new JRadioButton("TripleSplit");
		ButtonGroup group2 = new ButtonGroup();
		group2.add(TwoSplitButton);
		group2.add(ThreeSplitButton);
		if(!artDataFailed){
			cairnButton = new JButton(cairnIcon);
		}
		cairnButton.setBorder(new EmptyBorder(0,10,0,10));
		//r,g,b
		cairnButton.setBackground(new Color(240,240,255));
		cairnButton.setSelected(false);
		numberOfSplitsPanel.add(cairnButton);
		numberOfSplitsPanel.add(TwoSplitButton);
		numberOfSplitsPanel.add(ThreeSplitButton);
		numberOfSplitsPanel.add(new JLabel());
		numberOfSplitsPanel.add(new JLabel());
	}
	
	/**
	 * Adds all the panels together
	 */
	public void initialGUILayout(){
//		adds everything together
		main_Plugin_Window.getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints c1 = new GridBagConstraints();
		c1.weightx = 1.0;
		c1.gridx = 0;
		c1.gridy = 0;
		c1.gridwidth = 2;
		c1.gridheight = 2;
		main_Plugin_Window.getContentPane().add(numberOfSplitsPanel,c1);
		c1.gridx = 2;
		c1.gridy = 0;
		c1.gridwidth = 4;
		c1.gridheight = 2;
		main_Plugin_Window.getContentPane().add(utilityPanel,c1);
		c1.gridx = 6;
		c1.gridy = 0;
		c1.gridwidth = 4;
		c1.gridheight = 2;
		//main_Plugin_Window.getContentPane().add(RGBoptions,c1);
		main_Plugin_Window.getContentPane().add(nudgeOptions,c1);
		
		c1.gridx = 0;
		c1.gridy = 2;
		c1.gridwidth = 6;
		c1.gridheight = 2;
		
		main_Plugin_Window.getContentPane().add(instructions,c1);
		c1.gridx = 6;
		c1.gridy = 2;
		c1.gridwidth = GridBagConstraints.REMAINDER;
		c1.gridheight = 2;
		directionPanel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		
		main_Plugin_Window.getContentPane().add(directionPanel,c1);
	}
	
	public void addActionListeners(){
		copyButton.addActionListener(this);
		resetButton.addActionListener(this);
		
		OKButton.addActionListener(this);
		saveButton.addActionListener(this);
		saveBatchButton.addActionListener(this);
		openButton.addActionListener(this);
		openLastButton.addActionListener(this);
		initialiseButton.addActionListener(this);
		cairnButton.addActionListener(this);
		
		northButton.addActionListener(this);
		northButton10.addActionListener(this);
		eastButton.addActionListener(this);
		eastButton10.addActionListener(this);
		southButton.addActionListener(this);
		southButton10.addActionListener(this);
		westButton.addActionListener(this);
		westButton10.addActionListener(this);
		
	  	redRB.addActionListener(this);
	  	greenRB.addActionListener(this);
	  	blueRB.addActionListener(this);
	  	
	  	redC.addItemListener(this);
	  	greenC.addItemListener(this);
	  	blueC.addItemListener(this);
	  	profilerC.addItemListener(this);
	  	
		TwoSplitButton.addActionListener(this);
		ThreeSplitButton.addActionListener(this);
	}

	/*
	 * Finds out the source of the button pressed
	 */
	public void actionPerformed(ActionEvent e){
		 if(e.getSource() == initialiseButton){
			initialise();
			return;
	    }
		 if(WindowManager.getImage(firstImageID) == null){
			 JOptionPane.showMessageDialog(main_Plugin_Window,"Original Image closed, you must select an Image and press Initialise");
			 return;
		 }
		if(e.getSource() == copyButton){
			copy();
		}
		else if(e.getSource() == resetButton){	 
			reset();
		}
		else if(e.getSource() == OKButton){
			OK();
		}
		else if(e.getSource() == saveButton){
			save();
		}
		//not written yet
		//else if(e.getSource() == saveBatchButton){
			//start_Batch_Analyser();
		//}
			
		else if(e.getSource() == openButton){
			open();
	    }
		else if(e.getSource() == openLastButton){
			openLastAlignment();
	    }
		
		else if(e.getSource() == cairnButton){
			urlgoTO.displayURL("http://www.cairn-research.co.uk");
		}
		
		//the following control the nudging of the overlapped images
		else if(e.getSource() == northButton){
			nudgeImage(0, 1);
				
		}
		
		else if(e.getSource() == northButton10){
			nudgeImage(0, 10);
				
		}
		
		else if(e.getSource() == eastButton){
			nudgeImage(-1, 0);
	    }
		
		else if(e.getSource() == eastButton10){
			nudgeImage(-10, 0);
	    }
		
		else if(e.getSource() == southButton){
			nudgeImage(0, -1);
		}
		
		else if(e.getSource() == southButton10){
			nudgeImage(0, -10);
		}
		
		else if(e.getSource() == westButton){
			nudgeImage(1, 0);
	    }
		
		else if(e.getSource() == westButton10){
			nudgeImage(10, 0);
	    }
		else if(e.getSource() == redRB){
			nudgeRedStack = true;
			nudgeGreenStack = false;
			nudgeBlueStack = false;
			if(color!=null){
				setColorRed();
			}
		}
		else if(e.getSource() == greenRB){
			nudgeRedStack = false;
			nudgeGreenStack = true;
			nudgeBlueStack = false;
			_1_and_2.doClick();   //taking the reins, helping the user
			if(color!=null){
				setColorGreen();
			}
		}
		else if(e.getSource() == blueRB){
			nudgeRedStack = false;
			nudgeGreenStack = false;
			nudgeBlueStack = true;
			_1_and_3.doClick();
			if(color!=null){
				setColorBlue();
			}
		}
		
		else if(e.getSource() == TwoSplitButton){
			//use defult setings
			defaultSplitMode();
			instructions.setText(" OptoSplit II selected  \n \n" +
	        		" Please draw a rectangular region of interest around your first alignment grid image \n"+
	        		" Now press Select 1st Alignment");
		}
		else if(e.getSource() == ThreeSplitButton){
			tripleSplitMode();
			instructions.setText(" TripleSplit selected  \n \n" +
	        		" Please draw a rectangular region of interest around your first alignment grid image \n"+
	        		" Now press Select 1st Alignment");
	    }
	}
	
	public void initialise(){
		try{
			//ImagePlus originalImage=WindowManager.getCurrentImage();
			//firstImageID = originalImage.getID();
			reset();
			main_Plugin_Window.dispose();
			IJ.run("Cairn Image Splitter");
		}
		catch(NullPointerException e){
			JOptionPane.showMessageDialog(main_Plugin_Window,"Please open an image first");
		}
	}
	
	public void itemStateChanged(ItemEvent e){
		Object source = e.getItemSelectable();

	    if (source == redC) {
	    	if (e.getStateChange() == ItemEvent.DESELECTED){
	    		showRedStack = false;
	    		checkBoxMethods();
	    	}
	    	//its a select event
	    	else{
	    		showRedStack = true;
	    		checkBoxMethods();
	    	}
	    } 
	    else if (source == greenC) {
	    	if (e.getStateChange() == ItemEvent.DESELECTED){
	    		showGreenStack = false;
	    		checkBoxMethods();
	    	}
	    	else{
	    		showGreenStack = true;
	    		checkBoxMethods();
	    	}
	    } 
	    else if (source == blueC) {
	    	if (e.getStateChange() == ItemEvent.DESELECTED){
	    		showBlueStack = false;
	    		checkBoxMethods();
	    	}
	    	else{
	    		showBlueStack = true;
	    		checkBoxMethods();
	    	}
	    } 
	    else if (source == profilerC) {
	    	profilerStuff();
	    }
	}

	public void profilerStuff(){
		if (profilerC.isSelected() == false){
    		rgbProfiler.closePlotWindows();
    		profilerActivated = false;
    	}
    	else{
    		int width = WindowManager.getImage(rgbID).getWidth();
    	    int height = WindowManager.getImage(rgbID).getHeight(); 
    	    int xPos = width/2;
    	    int yPos = height/2;
    	    
    		int[] x = new int[1];
    		x[0] = xPos;
    		int[] y = new int[1];
    		y[0] = yPos;
    		
    		WindowManager.getImage(rgbID).setRoi(new PointRoi(x,y,1));
    		WindowManager.getImage(rgbID).repaintWindow();
    		
    		instructions.setText(" This function looks at the horizontal and vertical RGB profiles \n"+
    				" intersecting at the point ROI shown in the RGB image window.\n You can drag the point ROI \n"+
    				" to look at profiles at different locations.\n Aligned images will have slimilar waveforms in the profile windows \n but not necessayily have exact abosulte intensities\n\n"+
    				" Note: you must always use the point ROI to update the RGB profile windows.");
    		rgbProfiler = new RGBprofiler();
    		rgbProfiler.setup("",WindowManager.getImage(rgbID));
    		rgbProfiler.run(WindowManager.getImage(rgbID).getProcessor());
    		profilerActivated = true;
    		
    	
    	}
	}
	
	public void copy(){
		programState = DEFULT_PROGRAM_STATE;
		// JFrame.setDefaultLookAndFeelDecorated(true);
		ImagePlus impAP = WindowManager.getImage(firstImageID);
		ImageProcessor ipAP = impAP.getProcessor();
		copyCount++; 
		//copyCount lets us know how many previous imaged have been cropped
		if(copyCount == NO_IMAGE_CROPPED){
			 
			 r1 = new Rectangle(ipAP.getRoi());
			 buttonsAfterFirstCrop();
			 copyButton.setText(" Select 2nd Channel");
			 instructions.setText(" Now drag your selection box to another part of the image \n" +
					 " and press Select 2nd Channel\n\n"+
			 	" Note: it is important that you do not change the size of the ROI");
		}
		//second image to be cropped
		else if(copyCount == ONE_IMAGE_CROPPED ){
			profilerC.setEnabled(true);
			r2 = new Rectangle (ipAP.getRoi());
			buttonsAfterSecondCrop();
			nudgeRedStack = false;
			nudgeGreenStack = true;
			nudgeBlueStack = false;
			stopChannelIntensityEqualisation = false; //allow this feature if channelIntensityEqualisation checkbox selected
			processStacks();
			if(color!=null){
				setColorGreen();
			}
			if(profilerC.isSelected() == true){
				profilerStuff();
			}
			instructions.setText(" Nudge the RGB window so that the images are aligned \n" +
			" Then press OK");
			redRB.setEnabled(true);
			greenRB.setEnabled(true);
			redC.setEnabled(true);
			greenC.setEnabled(true);
			greenRB.setSelected(true);
			stopChannelIntensityEqualisation = false; //allow this feature if channelIntensityEqualisation checkbox selected
		}
		
		else if(copyCount == TWO_IMAGES_CROPPED && isThreeSplit){
			r3 = new Rectangle (ipAP.getRoi());
			if(RGBmode == SUBTRACTION){
				_1_and_2.setEnabled(true);
				_1_and_3.setEnabled(true);
			}
			// the same functionality of this method can be used here
			// even though its a triple split programe state
			buttonsAfterSecondCrop();
			nudgeRedStack = false;
			nudgeGreenStack = false;
			nudgeBlueStack = true;
			stopChannelIntensityEqualisation = false; //allow this feature if channelIntensityEqualisation checkbox selected
			_1_and_3.doClick();
			processTripleStacks();
			if(likesProfiler){
				profilerC.setSelected(true);
			}
			if(color!=null){
				setColorBlue();
			}
			instructions.setText(" Nudge the RGB window so that your imags are aligned \n" +
			" Then press OK\n\n"+
			" Note: you can change the nudge settings if RGB options if you \n"+
			" wish to nudge different channels");
		}
		
	}
	
	public void reset(){
		instructions.setText(" Reset...");
		defultSettingsUponReset();
		initialiseVariables();
		copyButton.setText(" Select 1st Channel");
		instructions.append(" done \n  Please select either OptoSplit II or TripleSplit\n"+
        		" Then draw a rectangular box around your first sub image \n"+
        		" Now press Select 1st Channel");
	}
	
	public Rectangle incrementAndCheck(Rectangle r, int x_pixelIncrement, int y_pixelIncrement){
		Point minPoint = new Point(0,0);
		int maxX = originalImage.getWidth();
		int maxY = originalImage.getHeight();
		Point maxPoint = new Point(maxX,maxY);
		
		r.x += x_pixelIncrement;
		//check bounds, if error condition return rectangle to original state
		if(r.x < minPoint.x || r.x > maxPoint.x - r.getWidth()){
			//do the reverse
			r.x -= x_pixelIncrement;
		//	instructions.append("\n\n Image xCoord boundary reached");
		}
		r.y += y_pixelIncrement;
		if(r.y < minPoint.y || r.y > maxPoint.y - r.getHeight()){
			//do the reverse
		//	instructions.append("\n\n Image yCoord boundary reached");
			r.y -= y_pixelIncrement;
		}
		// hand it back
		return r;
	}
	
	//nudges the images so that they get to be aligned 
	public void nudgeImage(int x_pixelIncrement, int y_pixelIncrement){
		if(nudgeRedStack){
			incrementAndCheck(r1,x_pixelIncrement,y_pixelIncrement);
			radioButton_and_profiler_Methods();
			if(profilerActivated){
				rgbProfiler.creatergb();
				rgbProfiler.updateProfile();
			}
		}
		else if(nudgeGreenStack){
			incrementAndCheck(r2,x_pixelIncrement,y_pixelIncrement);
			radioButton_and_profiler_Methods();
			if(profilerActivated){
				rgbProfiler.creatergb();
				rgbProfiler.updateProfile();
			}
		}
		else if(nudgeBlueStack){
			incrementAndCheck(r3,x_pixelIncrement,y_pixelIncrement);
			processTripleStacks();
			if(profilerActivated){
				rgbProfiler.creatergb();
				rgbProfiler.updateProfile();
				//profilerC.setSelected(false);
				//profilerC.setSelected(true);
			}
		}
		else if(isTwoSplit || copyCount == ONE_IMAGE_CROPPED){
			incrementAndCheck(r2,x_pixelIncrement,y_pixelIncrement);
			processStacks();
			if(profilerActivated){
				rgbProfiler.creatergb();
				rgbProfiler.updateProfile();
			}
		}
		else{
			incrementAndCheck(r3,x_pixelIncrement,y_pixelIncrement);
			processTripleStacks();
			if(profilerActivated){
				//rgbProfiler.updateProfile();
				profilerC.setSelected(false);
				rgbProfiler.creatergb();
				rgbProfiler.updateProfile();
			}
		}
	}
	
	public void OK(){
		if(isTwoSplit){
			twoAligned = true;
			// now when processStacks is called the whole original stack will be split 
			//with the current alignment, gets rid of the old alignment window
			//ImagePlus aboutToBeRemoved = WindowManager.getImage(rgbID);
			//aboutToBeRemoved.close();
			stopChannelIntensityEqualisation = true; //disallow this feature if channelIntensityEqualisation checkbox selected
			
			if( RGBmode == SUBTRACTION){
				 RGBmode = SEGMENTED;   // want rgb images for this
				processStacks();
				RGBmode = SUBTRACTION;   
			}
			else{
				processStacks();   //just go ahead rgb mode is already in correct setting
			}
			buttonsAfterOK();
			setColorGrey();
			instructions.setText(" You now have the 2 split images and the Combined RGB images\n" +
					" If you were using an alignment grid you can save the alignment settings \n" +
					" For use with other images");
			disableRGBPanel();
			if(rgbProfiler != null){
				rgbProfiler.closePlotWindows();
				profilerC.setSelected(false);
				//this means that for triplesplit the next time select roi is pressed the
				//rgb profiler opens automatically
				
			}
			
		}
		else if(isThreeSplit && copyCount == ONE_IMAGE_CROPPED){
			copyButton.setEnabled(true);
			buttonsAfterOK();
			setColorGrey();
			copyButton.setText(" Select 3rd channel");
			instructions.setText(" Now drag your selection box to another part of the image \n" +
			 " and press Select 3rd Channel \n\n"+
			 " Note: it is important that you do not change the size of the ROI");
			disableRGBPanel();
			if(rgbProfiler != null){
				rgbProfiler.closePlotWindows();
				profilerC.setSelected(false);
				 likesProfiler = true;
			}
			stopChannelIntensityEqualisation = true; //disallow this feature if channelIntensityEqualisation checkbox selected
			
		}
		else if(isThreeSplit && copyCount == TWO_IMAGES_CROPPED){
			stopChannelIntensityEqualisation = true; //disallow this feature if channelIntensityEqualisation checkbox selected
			
			copyButton.setEnabled(false);
			threeAligned = true;
			buttonsAfterOK();
			//go through this method one last time going through the stacks
			// because threeAligned is now true
			if( RGBmode == SUBTRACTION){
				 RGBmode = SEGMENTED;   // want rgb images for this
				 processTripleStacks();
				RGBmode = SUBTRACTION;   
			}
			else{
				processTripleStacks();   //just go ahead rgb mode is already in correct setting
			}
			
			setColorGrey();
			saveButton.setEnabled(true);
			instructions.setText(" You now have the 3 split images and the Combined RGB images\n" +
					" If you were using an alignment grid you can save the alignment settings \n" +
					" For use with other images");
			stopChannelIntensityEqualisation = true; //disallow this feature if channelIntensityEqualisation checkbox selected
			
		}
		if(rgbProfiler != null){
			rgbProfiler.closePlotWindows();
		}
		disableRGBPanel();
	}
	
	public void save(){
		
		try{

			fc.setDialogTitle("Save your alignment");
			int returnVal = fc.showSaveDialog(null);

	        if (returnVal == JFileChooser.APPROVE_OPTION) {
	            File file = fc.getSelectedFile();
	            File reNamedFile = new File(file.getPath() + ".ali");
	            
	            FileOutputStream fos = new FileOutputStream(reNamedFile);
	            ObjectOutputStream oos = new ObjectOutputStream(fos);
			
	            oos.writeObject(r1);
	            oos.writeObject(r2);
	            //don't right is threeSPlit
	            if(r3 != null && isThreeSplit){
	            	oos.writeObject(r3);
	            	}
	            //oos.writeObject(new Date());

	            oos.close();
	            
	            //now write the same rectangles into the ImageJ directory so that
	            //the user can open this by pressing Open Last Alignment
	            
	            fos = new FileOutputStream(currDir + "Last_Alignment.tmp");
	            oos = new ObjectOutputStream(fos);
			
	            oos.writeObject(r1);
	            oos.writeObject(r2);
	            //don't right is threeSPlit
	            if(r3 != null){
	            	oos.writeObject(r3);
	            	}

	            oos.close();
	            
				saveButton.setEnabled(false);
				instructions.setText(" You can now open these alignment settings by pressing Open Last Alignment\n" +
						" Alternatively you can use alignment files to process a batch of images\n"+
						" You can select what images to extract in the batch process under Advanced");
			}
		}
			catch(IOException ee){
				JOptionPane.showMessageDialog(main_Plugin_Window,"Something went wrong with saving");
			}
	}
	

	
	public void open(){
		programState = OPEN_ALIGNMENT_PROGRAM_STATE;
		boolean last2split = isTwoSplit;
		boolean last3split = isThreeSplit;
		
		try{
	
	        int returnVal = openAlignfc.showOpenDialog(null);
	        

	        if (returnVal == JFileChooser.APPROVE_OPTION) {
	            File file = openAlignfc.getSelectedFile();
	        
				FileInputStream fis = new FileInputStream(file);
				ObjectInputStream ois = new ObjectInputStream(fis);
				try{
					r1 = (Rectangle) ois.readObject();
					r2 = (Rectangle) ois.readObject();
				
					try{
						r3 = (Rectangle) ois.readObject();
						isTwoSplit = false;
						isThreeSplit = true;
					}
					catch(IOException e){
						System.out.println("no rectangle 3");
						isTwoSplit = true;
						isThreeSplit = false;
					}
					//set up the booleans so that the method processStacks() works
				 
					//although already aligned this is false to let the programe wait
					//until any RGB intensity modifications are done
					twoAligned = false;
				
					//assumes no combined image has been shown yet
					hasFirstRGBbeenShown =false;
					//get rid of previous images
					closePluginImages();
					//need to repeat because of the construction of the processStacks method
					if(isTwoSplit){
						processStacks();
						twoAligned = true;
						if(!errorFound){
							processStacks();
						}
					}
					else if(isThreeSplit){
						processStacks();
						// go straight to process whole stack mode
						threeAligned = true;
						processTripleStacks();
					}
					//make sure this is defult after reaching here
					errorFound = false;
					copyButton.setEnabled(false);
				}
				catch(ClassNotFoundException cnf){
					JOptionPane.showMessageDialog(main_Plugin_Window,"ClassNotFoundException");
				}
				resetButton.setEnabled(true);
	
				ois.close();
			}
		}
		catch(IOException ee){
			JOptionPane.showMessageDialog(main_Plugin_Window,"Something went wrong with opening");
		}	
		 isTwoSplit =last2split;  //restore the origninals
		 isThreeSplit =last3split;
		 r3 = null;  //don't want to remember this in case the user saves two split
	}
	
	public void openLastAlignment(){
		boolean last2split = isTwoSplit;
		boolean last3split = isThreeSplit;
		
		try{
			FileInputStream fis = new FileInputStream(currDir + "Last_Alignment.tmp");
			ObjectInputStream ois = new ObjectInputStream(fis);
			try{
				r1 = (Rectangle) ois.readObject();
				r2 = (Rectangle) ois.readObject();
			
				try{
					r3 = (Rectangle) ois.readObject();
					isTwoSplit = false;
					isThreeSplit = true;
				}
				catch(IOException e){
					System.out.println("no rectangle 3");
					isTwoSplit = true;
					isThreeSplit = false;
				}
				
				//set up the booleans so that the method processStacks() works
			 
				//although already aligned this is false to let the programe wait
				//until any RGB intensity modifications are done
				twoAligned = false;
			
				//assumes no combined image has been shown yet
				hasFirstRGBbeenShown =false;
				//get rid of previous images
				closePluginImages();
				//need to repeat because of the construction of the processStacks method
				if(isTwoSplit){
					processStacks();
					twoAligned = true;
					if(!errorFound){
						processStacks();
					}
				}
				else if(isThreeSplit){
					processStacks();
					// go straight to process whole stack mode
					threeAligned = true;
					processTripleStacks();
				}
				//make sure this is defult after reaching here
				errorFound = false;
				copyButton.setEnabled(false);
			}
			catch(ClassNotFoundException cnf){
				JOptionPane.showMessageDialog(main_Plugin_Window,"ClassNotFoundException");
			}
			resetButton.setEnabled(true);

			ois.close();
			}
		catch(IOException ee){
			JOptionPane.showMessageDialog(main_Plugin_Window,"Something went wrong with opening");
		}	
		 isTwoSplit =last2split;  //restore the origninals
		 isThreeSplit =last3split;
		 r3 = null;
	}
	
	
	/**
	 * This method iterates through the data and extracts the data needed to overlay images
	 * in the RGB nudge window. It also contains the functionality to crop the images from
	 * the original image. It passes this data to be processed by the MergeStacks method.
	 */
	public void processStacks(){
	ImagePlus imp=WindowManager.getImage(firstImageID);

	// checks on image and stack
	if (imp==null) {
		JOptionPane.showMessageDialog(main_Plugin_Window,"No image open!");
		return;
	}
	String title=imp.getTitle();
	boolean isstack=(imp.getStackSize()!=1);

	if (isstack && twoAligned) {
		//close the RGB image as this will be replaced by the RGB stack
		try{
			WindowManager.getImage(rgbID).close();
				}
		catch(Exception e){	}
		// get new stack widths
		ImageStack stack=imp.getStack();
		
		ColorModel cm=imp.createLut().getColorModel();

		// copy the left and right to  new stacks
		ImageStack leftstack=new ImageStack(r1.width, r1.height, cm);
		String slicename="slice_";
		for (int n=1; n<=imp.getStackSize();n++) {
			ImageProcessor theslice=stack.getProcessor(n);
			theslice.setRoi(r1);
			leftstack.addSlice(slicename+n,theslice.crop());
		}
		ImagePlus leftimage=new ImagePlus( _1stChannelName(title),leftstack);
		//get the ID of this imageplus for future use
		leftImageID = leftimage.getID();
		leftimage.show();
		//display the window in a user friendy way to avoid clutter
		int h = leftimage.getWindow().getHeight();
		if(screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
			leftimage.getWindow().setLocation(0, screenSize.height - h - SPLITS_FROM_BOTTOM);
		}
		leftimage.updateAndDraw();

		ImageStack rightstack=new ImageStack(r2.width, r2.height, cm);
		slicename="slice_";
		for (int n=1; n<=imp.getStackSize();n++) {
			ImageProcessor theslice=stack.getProcessor(n);
			theslice.setRoi(r2);
			rightstack.addSlice(slicename+n,theslice.crop());
		}
		ImagePlus rightimage=new ImagePlus(_2ndChannelName(title),rightstack);
		//get the ID of this imageplus for future use
		rightImageID = rightimage.getID();
		rightimage.show();
		int w = rightimage.getWindow().getWidth();
		 h = rightimage.getWindow().getHeight();
		 if(w <= screenSize.width - 20 && screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
			 rightimage.getWindow().setLocation(w, screenSize.height - h - SPLITS_FROM_BOTTOM);
			}
		rightimage.updateAndDraw();
		// convert copies of stacks to 8bits and merge into RGB stack
		ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
		ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
		for (int n=1; n<=imp.getStackSize();n++) {
			greyleftStack.addSlice("1",leftstack.getProcessor(n).convertToByte(true));
			greyrightStack.addSlice("1",rightstack.getProcessor(n).convertToByte(true));
		}
		ImageStack rgb=MergeStacks(r1.width, r1.height,imp.getStackSize(),greyleftStack,greyrightStack,null,true);
		ImagePlus rgbStackPlus = new ImagePlus("RGB",rgb);
		 stackrgbID = rgbStackPlus.getID();
		 
		rgbStackPlus.show();
	    w = rgbStackPlus.getWindow().getWidth();
		h = rgbStackPlus.getWindow().getHeight();
		
		if(w <= screenSize.width - 20 ){ //don't let it display out of bounds
			 rgbStackPlus.getWindow().setLocation(screenSize.width - w, 0);
			}
			
	}

	else { // not a stack
		ImageProcessor theimpr=imp.getProcessor();
		
		ImageProcessor leftimpr=theimpr.createProcessor(r1.width, r1.height);
		ImageProcessor rightimpr=theimpr.createProcessor(r2.width, r2.height);
		
		
		theimpr.setRoi(r1);
		leftimpr=theimpr.crop();
		theimpr.setRoi(r2);
		rightimpr=theimpr.crop();
		
	
		
		ImagePlus leftimage=new ImagePlus(_1stChannelName(title),leftimpr);
		//again getting the id
		leftImageID = leftimage.getID();
		if(twoAligned){
			leftimage.show();
			//display the window in a user friendy way to avoid clutter
			int h = leftimage.getWindow().getHeight();
			if(screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
				leftimage.getWindow().setLocation(0, screenSize.height - h - SPLITS_FROM_BOTTOM);
			}
		}
		leftimage.updateAndDraw();
		ImagePlus rightimage=new ImagePlus(_2ndChannelName(title),rightimpr);
		//again getting the id
		rightImageID = rightimage.getID();
		if(twoAligned){
			rightimage.show();
			int w = rightimage.getWindow().getWidth();
			int h = rightimage.getWindow().getHeight();
			rightimage.getWindow().setLocation(w, screenSize.height - h - SPLITS_FROM_BOTTOM);
		}
		rightimage.updateAndDraw();

		// create an rgb image and merge left and right (after conversion to 8 bit greyscale stack
		ImageProcessor greyleftimpr=leftimpr.convertToByte(true);
		ImageProcessor greyrightimpr=rightimpr.convertToByte(true);
		
		//test to see whats going on
		// new ImagePlus("tese",greyrightimpr).show();
		try{
			ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
			greyleftStack.addSlice("1",greyleftimpr);
			ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
			greyrightStack.addSlice("1",greyrightimpr);
			//imp.getStackSize()where 1 is
			ImageStack rgb=MergeStacks(r1.width, r1.height,1,greyleftStack,greyrightStack,null,true);
			ImagePlus rgbIm = new ImagePlus("RGB",rgb);
			ImageProcessor ip = rgbIm.getProcessor();
			if(!hasFirstRGBbeenShown){
				rgbIm.show();
				int w = rgbIm.getWindow().getWidth();
				if(w <= screenSize.width - 20 ){ //don't let it display out of bounds
					rgbIm.getWindow().setLocation(screenSize.width - w, 0);
					}
				rgbID = rgbIm.getID();
			}
//			makes sure that we don't have a null pointer exception
			if(hasFirstRGBbeenShown){
				ImagePlus modified=WindowManager.getImage(rgbID);
				modified.setProcessor("RGB", ip);
				modified.updateAndDraw();
			}
			
			//this only gets set the first time this method gets called
			//		tidy this up later
			hasFirstRGBbeenShown = true;
			
			// makes sure the garbage collector doesn't forget to remove these!
			if(!twoAligned){
				leftimage.killProcessor();
				leftimage.close();
				rightimage.killProcessor();
				rightimage.close();
			}
		}
		catch(NullPointerException Ille){
			
            //stop proceding until reset
			copyButton.setEnabled(false);
			errorFound = true;
			JOptionPane.showMessageDialog(main_Plugin_Window,"You have nudged a channel out of bounds \n " +
					"Or you have an Image which has a different size from the one \n" +
					"used in the alignment setup");
		}
		

	  }
	}
	
	//a method similar to processStacks() except for the triple splitter
	public void processTripleStacks(){
		ImagePlus imp=WindowManager.getImage(firstImageID);

		// checks on image and stack
		if (imp==null) {
			JOptionPane.showMessageDialog(main_Plugin_Window,"No image open!");
			return;
		}
		boolean isstack=(imp.getStackSize()!=1);
		String title=imp.getTitle();
		
		if (isstack && threeAligned) {
			//close the RGB image as this will be replaced by the RGB stack
			try{
				WindowManager.getImage(rgbID).close();
					}
			catch(Exception e){	}
			// get new stack widths
			ImageStack stack=imp.getStack();
			
			ColorModel cm=imp.createLut().getColorModel();

			// copy the left and right to  new stacks
			ImageStack leftstack=new ImageStack(r1.width, r1.height, cm);
			String slicename="slice_";
			for (int n=1; n<=imp.getStackSize();n++) {
				ImageProcessor theslice=stack.getProcessor(n);
				theslice.setRoi(r1);
				leftstack.addSlice(slicename+n,theslice.crop());
			}
			ImagePlus leftimage=new ImagePlus(title + "_Channel_1",leftstack);
			//get the ID of this imageplus for future use
			leftImageID = leftimage.getID();
			leftimage.show();
			//display the window in a user friendy way to avoid clutter
			int h = leftimage.getWindow().getHeight();
			if(screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
				leftimage.getWindow().setLocation(0, screenSize.height - h - SPLITS_FROM_BOTTOM);
			}
			leftimage.updateAndDraw();

			ImageStack rightstack=new ImageStack(r2.width, r2.height, cm);
			slicename="slice_";
			for (int n=1; n<=imp.getStackSize();n++) {
				ImageProcessor theslice=stack.getProcessor(n);
				theslice.setRoi(r2);
				rightstack.addSlice(slicename+n,theslice.crop());
			}
			ImagePlus rightimage=new ImagePlus(title + "_Channel_2",rightstack);
			//get the ID of this imageplus for future use
			rightImageID = rightimage.getID();
			rightimage.show();
			int w = rightimage.getWindow().getWidth();
			 h = rightimage.getWindow().getHeight();
			 if(w <= screenSize.width - 20 && screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
				 rightimage.getWindow().setLocation(w, screenSize.height - h - SPLITS_FROM_BOTTOM);
				}
			rightimage.updateAndDraw();
			
			ImageStack thirdstack=new ImageStack(r3.width, r3.height, cm);
			slicename="slice_";
			for (int n=1; n<=imp.getStackSize();n++) {
				ImageProcessor theslice=stack.getProcessor(n);
				theslice.setRoi(r3);
				thirdstack.addSlice(slicename+n,theslice.crop());
			}
			ImagePlus thirdimage=new ImagePlus("Channel 3",thirdstack);
			//get the ID of this imageplus for future use
			thirdImageID = thirdimage.getID();
			thirdimage.show();
			 w = thirdimage.getWindow().getWidth();
			 h = thirdimage.getWindow().getHeight();
			 
			 if(w*2 <= screenSize.width - 20 && screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
				 thirdimage.getWindow().setLocation(w*2, screenSize.height - h - SPLITS_FROM_BOTTOM);
				}
			thirdimage.updateAndDraw();
			
			// convert copies of stacks to 8bits and merge into RGB stack
			ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
			ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
			ImageStack greythirdStack=new ImageStack(r3.width, r3.height);
			for (int n=1; n<=imp.getStackSize();n++) {
				greyleftStack.addSlice("1",leftstack.getProcessor(n).convertToByte(true));
				greyrightStack.addSlice("1",rightstack.getProcessor(n).convertToByte(true));
				greythirdStack.addSlice("1",thirdstack.getProcessor(n).convertToByte(true));
			}
			ImageStack rgb=MergeStacks(r1.width, r1.height,imp.getStackSize(),greyleftStack,greyrightStack,greythirdStack,true);
			ImagePlus rgbStackPlus = new ImagePlus("RGB",rgb);
			stackrgbID = rgbStackPlus.getID();
			rgbStackPlus.show();
		    w = rgbStackPlus.getWindow().getWidth();
		    if(w <= screenSize.width - 20 ){ //don't let it display out of bounds
		    	rgbStackPlus.getWindow().setLocation(screenSize.width - w, 0);
			}
		}
		else { // not a stack
			
			ImageProcessor theimpr=imp.getProcessor();
			
			ImageProcessor leftimpr=theimpr.createProcessor(r1.width, r1.height);
			ImageProcessor rightimpr=theimpr.createProcessor(r2.width, r2.height);
            //a third image processor  for triple splitters
			
				ImageProcessor thirdimpr = theimpr.createProcessor(r3.width, r3.height);
			
			
			theimpr.setRoi(r1);
			leftimpr=theimpr.crop();
			theimpr.setRoi(r2);
			rightimpr=theimpr.crop();
			//we need to repeat this for Rectangle r3
			theimpr.setRoi(r3);	
			thirdimpr=theimpr.crop();
		
			ImagePlus leftimage=new ImagePlus(title + "_Channel_1",leftimpr);
			//again getting the id
			leftImageID = leftimage.getID();
			if(threeAligned){
				leftimage.show();
				//display the window in a user friendy way to avoid clutter
				int h = leftimage.getWindow().getHeight();
				if(screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
					leftimage.getWindow().setLocation(0, screenSize.height - h - SPLITS_FROM_BOTTOM);
				}
			}
			leftimage.updateAndDraw();
			
			ImagePlus rightimage=new ImagePlus(title + "_Channel_2",rightimpr);
			//again getting the id
			rightImageID = rightimage.getID();
			if(threeAligned){
				rightimage.show();
				int w = rightimage.getWindow().getWidth();
				 int h = rightimage.getWindow().getHeight();
				 if(w <= screenSize.width - 20 && screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
					 rightimage.getWindow().setLocation(w, screenSize.height - h - SPLITS_FROM_BOTTOM);
					}
			}
			rightimage.updateAndDraw();


			ImagePlus thirdimage=new ImagePlus("Channel 3",thirdimpr);
			//again getting the id
			thirdImageID = thirdimage.getID();
			if(threeAligned){
				thirdimage.show();
				int w = thirdimage.getWindow().getWidth();
				int h = thirdimage.getWindow().getHeight();
				if(w*2 <= screenSize.width - 20 && screenSize.height - h - SPLITS_FROM_BOTTOM >= 0){ //don't let it display out of bounds
					 thirdimage.getWindow().setLocation(w*2, screenSize.height - h - SPLITS_FROM_BOTTOM);
					}
			}
			thirdimage.updateAndDraw();
			
				
			
			
			// create an rgb image and merge left and right
			//and the third images(after conversion to 8 bit greyscale stack
			
			ImageProcessor greyleftimpr=leftimpr.convertToByte(true);
			ImageProcessor greyrightimpr=rightimpr.convertToByte(true);
			ImageProcessor greythirdimpr=thirdimpr.convertToByte(true);
			
			try{
				ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
				greyleftStack.addSlice("1",greyleftimpr);
				ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
				greyrightStack.addSlice("1",greyrightimpr);
				ImageStack greythirdStack=new ImageStack(r3.width, r3.height);
				greythirdStack.addSlice("1",greythirdimpr);

				ImageStack rgb=MergeStacks(r1.width, r1.height,1,greyleftStack,greyrightStack,greythirdStack,true);
				ImagePlus rgbIm = new ImagePlus("RGB",rgb);
				ImageProcessor ip = rgbIm.getProcessor();
				
				    //don't have to perform check that rgb has been shown because
				    //processStacks() drew it already after the 2nd crop
					ImagePlus modified=WindowManager.getImage(rgbID);
					modified.setProcessor("RGB (nudge watch)", ip);
					modified.updateAndDraw();

				    int w = modified.getWindow().getWidth();
				    if(w <= screenSize.width - 20 ){ //don't let it display out of bounds
				    	modified.getWindow().setLocation(screenSize.width - w, 0);
					}	
				
				
				//not implimented
				// makes sure the garbage collector doesn't forget to remove these!
			//	if(!threeAligned){
				//	leftimage.killProcessor();
				//	leftimage.close();
				//	rightimage.killProcessor();
				//	rightimage.close();
				//	thirdimage.killProcessor();
				//	thirdimage.close();
				//}
			}
			catch(IllegalArgumentException Ille){
				
				//stop proceding until reset
				copyButton.setEnabled(false);
				instructions.setText("Please press reset");
				JOptionPane.showMessageDialog(main_Plugin_Window,"You have nudged a channel out of bounds \n " +
						"Or you have an Image which has a different size from the one \n" +
						"used in the alignment setup");
				
			}
			

		  }
	}
	
	/*
	 * This method iterates through the data for batch processing of images
	 */
	public void processStacksForBatch(){
	
	ImagePlus imp = Bimg;
	
	// checks on image and stack
	if (imp==null) {
		JOptionPane.showMessageDialog(main_Plugin_Window,"No image open!");
		return;
	}
	String title=imp.getTitle();
	boolean isstack=(imp.getStackSize()!=1);

	if (isstack && twoAligned) {
		// get new stack widths
		ImageStack stack=imp.getStack();
		
		ColorModel cm=imp.createLut().getColorModel();

		// copy the left and right to  new stacks
		ImageStack leftstack=new ImageStack(r1.width, r1.height, cm);
		String slicename="slice_";
		for (int n=1; n<=imp.getStackSize();n++) {
			ImageProcessor theslice=stack.getProcessor(n);
			theslice.setRoi(r1);
			leftstack.addSlice(slicename+n,theslice.crop());
		}
		ImagePlus leftimage=new ImagePlus(_1stChannelName(title),leftstack);
		//get the ID of this imageplus for future use
		leftImageID = leftimage.getID();
		batchImages[0] = leftimage;

		ImageStack rightstack=new ImageStack(r2.width, r2.height, cm);
		slicename="slice_";
		for (int n=1; n<=imp.getStackSize();n++) {
			ImageProcessor theslice=stack.getProcessor(n);
			theslice.setRoi(r2);
			rightstack.addSlice(slicename+n,theslice.crop());
		}
		ImagePlus rightimage=new ImagePlus(_2ndChannelName(title),rightstack);
		//get the ID of this imageplus for future use
		rightImageID = rightimage.getID();
		batchImages[1] = rightimage;
		
		// convert copies of stacks to 8bits and merge into RGB stack
		ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
		ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
		for (int n=1; n<=imp.getStackSize();n++) {
			greyleftStack.addSlice("1",leftstack.getProcessor(n).convertToByte(true));
			greyrightStack.addSlice("1",rightstack.getProcessor(n).convertToByte(true));
		}
		ImageStack rgb=MergeStacks(r1.width, r1.height,imp.getStackSize(),greyleftStack,greyrightStack,null,true);
		ImagePlus rgbStackPlus = new ImagePlus(RGBChannelName(title),rgb);
		 batchImages[3] = rgbStackPlus;
		 
		 
		 
		 
		 
		 
	}

	else { // not a stack
		ImageProcessor theimpr=imp.getProcessor();
		
		ImageProcessor leftimpr=theimpr.createProcessor(r1.width, r1.height);
		ImageProcessor rightimpr=theimpr.createProcessor(r2.width, r2.height);
		
		
		theimpr.setRoi(r1);
		leftimpr=theimpr.crop();
		theimpr.setRoi(r2);
		rightimpr=theimpr.crop();
		
	
		
		ImagePlus leftimage=new ImagePlus(_1stChannelName(title),leftimpr);
		//again getting the id
		leftImageID = leftimage.getID();
		batchImages[0] = leftimage;
		ImagePlus rightimage=new ImagePlus(_2ndChannelName(title),rightimpr);
		//again getting the id
		rightImageID = rightimage.getID();
		batchImages[1] = rightimage;

		// create an rgb image and merge left and right (after conversion to 8 bit greyscale stack
		ImageProcessor greyleftimpr=leftimpr.convertToByte(true);
		ImageProcessor greyrightimpr=rightimpr.convertToByte(true);
		
		//test to see whats going on
		// new ImagePlus("tese",greyrightimpr).show();
		try{
			ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
			greyleftStack.addSlice("1",greyleftimpr);
			ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
			greyrightStack.addSlice("1",greyrightimpr);
			
			ImageStack rgb=MergeStacks(r1.width, r1.height,1,greyleftStack,greyrightStack,null,true);
			ImagePlus rgbIm = new ImagePlus(RGBChannelName(title),rgb);
			 batchImages[3] = rgbIm;
			//this only gets set the first time this method gets called
			//		tidy this up later
			hasFirstRGBbeenShown = true;
			
			// makes sure the garbage collector doesn't forget to remove these!
			if(!twoAligned){
				leftimage.killProcessor();
				leftimage.close();
				rightimage.killProcessor();
				rightimage.close();
			}
		}
		catch(NullPointerException Ille){
			
            //stop proceding until reset
			copyButton.setEnabled(false);
			errorFound = true;
			JOptionPane.showMessageDialog(main_Plugin_Window,"You have nudged a channel out of bounds \n " +
					"Or you have an Image which has a different size from the one \n" +
					"used in the alignment setup");
		}
		

	  }
	}
	
	public void processTripleStacksForBatch(){
		
		ImagePlus imp = Bimg;
		
		// checks on image and stack
		if (imp==null) {
			JOptionPane.showMessageDialog(main_Plugin_Window,"No image open!");
			return;
		}
		String title=imp.getTitle();
		boolean isstack=(imp.getStackSize()!=1);

		if (isstack && threeAligned) {
			// get new stack widths
			ImageStack stack=imp.getStack();
			
			ColorModel cm=imp.createLut().getColorModel();

			// copy the left and right to  new stacks
			ImageStack leftstack=new ImageStack(r1.width, r1.height, cm);
			String slicename="slice_";
			for (int n=1; n<=imp.getStackSize();n++) {
				ImageProcessor theslice=stack.getProcessor(n);
				theslice.setRoi(r1);
				leftstack.addSlice(slicename+n,theslice.crop());
			}
			ImagePlus leftimage=new ImagePlus(_1stChannelName(title),leftstack);
			//get the ID of this imageplus for future use
			leftImageID = leftimage.getID();
			batchImages[0] = leftimage;

			ImageStack rightstack=new ImageStack(r2.width, r2.height, cm);
			slicename="slice_";
			for (int n=1; n<=imp.getStackSize();n++) {
				ImageProcessor theslice=stack.getProcessor(n);
				theslice.setRoi(r2);
				rightstack.addSlice(slicename+n,theslice.crop());
			}
			ImagePlus rightimage=new ImagePlus(_2ndChannelName(title),rightstack);
			//get the ID of this imageplus for future use
			rightImageID = rightimage.getID();
			batchImages[1] = rightimage;
			
			ImageStack thirdstack=new ImageStack(r3.width, r3.height, cm);
			slicename="slice_";
			for (int n=1; n<=imp.getStackSize();n++) {
				ImageProcessor theslice=stack.getProcessor(n);
				theslice.setRoi(r3);
				thirdstack.addSlice(slicename+n,theslice.crop());
			}
			ImagePlus thirdimage=new ImagePlus(_3rdChannelName(title),leftstack);
			batchImages[2] = thirdimage;
			
			// convert copies of stacks to 8bits and merge into RGB stack
			ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
			ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
			ImageStack greythirdStack=new ImageStack(r3.width, r3.height);
			for (int n=1; n<=imp.getStackSize();n++) {
				greyleftStack.addSlice("1",leftstack.getProcessor(n).convertToByte(true));
				greyrightStack.addSlice("1",rightstack.getProcessor(n).convertToByte(true));
				greythirdStack.addSlice("1",thirdstack.getProcessor(n).convertToByte(true));
			}
			ImageStack rgb=MergeStacks(r1.width, r1.height,imp.getStackSize(),greyleftStack,greyrightStack,greythirdStack,true);
			ImagePlus rgbStackPlus = new ImagePlus(RGBChannelName(title),rgb);
			 batchImages[3] = rgbStackPlus;
		}

		else { // not a stack
			ImageProcessor theimpr=imp.getProcessor();
			
			ImageProcessor leftimpr=theimpr.createProcessor(r1.width, r1.height);
			ImageProcessor rightimpr=theimpr.createProcessor(r2.width, r2.height);
			ImageProcessor thirdimpr = theimpr.createProcessor(r3.width, r3.height);
			
			theimpr.setRoi(r1);
			leftimpr=theimpr.crop();
			theimpr.setRoi(r2);
			rightimpr=theimpr.crop();
			theimpr.setRoi(r3);	
			thirdimpr=theimpr.crop();
		
			
			ImagePlus leftimage=new ImagePlus(_1stChannelName(title),leftimpr);
			//again getting the id
			leftImageID = leftimage.getID();
			batchImages[0] = leftimage;
			ImagePlus rightimage=new ImagePlus(_2ndChannelName(title),rightimpr);
			//again getting the id
			rightImageID = rightimage.getID();
			batchImages[1] = rightimage;

			ImagePlus thirdimage=new ImagePlus(_3rdChannelName(title),thirdimpr);
			//again getting the id
			thirdImageID = thirdimage.getID();
			batchImages[2] = thirdimage;
			
			// create an rgb image and merge left and right (after conversion to 8 bit greyscale stack
			ImageProcessor greyleftimpr=leftimpr.convertToByte(true);
			ImageProcessor greyrightimpr=rightimpr.convertToByte(true);
			ImageProcessor greythirdimpr=thirdimpr.convertToByte(true);
			
			try{
				ImageStack greyleftStack=new ImageStack(r1.width, r1.height);
				greyleftStack.addSlice("1",greyleftimpr);
				ImageStack greyrightStack=new ImageStack(r2.width, r2.height);
				greyrightStack.addSlice("1",greyrightimpr);
				ImageStack greythirdStack=new ImageStack(r3.width, r3.height);
				greythirdStack.addSlice("1",greythirdimpr);

				ImageStack rgb=MergeStacks(r1.width, r1.height,1,greyleftStack,greyrightStack,greythirdStack,true);
				ImagePlus rgbIm = new ImagePlus(RGBChannelName(title),rgb);
				 batchImages[3] = rgbIm;
				//this only gets set the first time this method gets called
				//		tidy this up later
				hasFirstRGBbeenShown = true;
				
				// makes sure the garbage collector doesn't forget to remove these!
				if(!twoAligned){
					leftimage.killProcessor();
					leftimage.close();
					rightimage.killProcessor();
					rightimage.close();
				}
			}
			catch(NullPointerException Ille){
				
	            //stop proceding until reset
				copyButton.setEnabled(false);
				errorFound = true;
				JOptionPane.showMessageDialog(main_Plugin_Window,"You have nudged a channel out of bounds \n " +
						"Or you have an Image which has a different size from the one \n" +
						"used in the alignment setup");
			}
		}
	}
	
	/**
	 * I modifed this method from the ImageJ plugins website to have functionality for a 3 way split rather than a 2 way split
	 * I also added the the intensity equalisation and subtaction algorithms
	 */
	public ImageStack MergeStacks(int w, int h, int d, ImageStack red, ImageStack green, ImageStack blue, boolean keep) {
		
		ImageStack rgb = new ImageStack(w, h);
		int inc = d/10;
		if (inc<1) inc = 1;
		ColorProcessor cp;
		int slice = 1;
		byte[] blank = new byte[w*h];
		byte[] redPixels, greenPixels, bluePixels;
	    	
		
		////////////////////////////////////////////
	
		//pixels[i] = (byte)(255-pixels[i]);
		
		///////////////////////////////////////
		
		try {
	    	for (int i=1; i<=d; i++) {
			cp = new ColorProcessor(w, h);
	    		redPixels = red!=null?(byte[])red.getPixels(slice):blank;   //if null fill in blank canvas, ie all pixel values = 0
	    		greenPixels = green!=null?(byte[])green.getPixels(slice):blank;
	    		bluePixels = blue!=null?(byte[])blue.getPixels(slice):blank;
	    		
	    		
	    		// if user wants channel intesnsity equalisation   and it is the appropriate time to perform it by the test  !stopChannelIntensityEqualisation
	    		if(channelIntensityEqualisation.isSelected() && !stopChannelIntensityEqualisation ){  //normalise algorithim to correct for different brightness for different channels for channel subtraction
	    			double totalRed = 0;		//used in in the scalefactor calculation
	    			double totalGreen = 0;
	    			double totalBlue = 0;
    				
    				for (int j=0; j<redPixels.length; j++){
    					int redTemp = redPixels[j] & 0xFF;        	//temp because easier for code readability
    					int greenTemp = greenPixels[j] & 0xFF;
    					int blueTemp = bluePixels[j] & 0xFF;
    					totalRed += redTemp; 					//used in in the scalefactor calculation
    					totalGreen += greenTemp;				//used in in the scalefactor calculation
    					totalBlue += blueTemp;					//used in in the scalefactor calculation
    				}    				
    				
    				
    				if(totalRed > totalGreen && totalRed > totalBlue){
    					
    					double scaleFactorG =  totalRed / totalGreen;
    					double scaleFactorB =  totalRed / totalBlue;
    					for (int j=0; j<redPixels.length; j++){
    						int greenTemp = greenPixels[j] & 0xFF;
    						int blueTemp = bluePixels[j] & 0xFF;
    						if(greenTemp *  scaleFactorG > 255){  // check for going over max pixel intensity
    							greenPixels[j] = (byte)255;   // the max value
    						}
    						else{
    							greenPixels[j] =(byte) (greenTemp *  scaleFactorG);  //bring the green channel intensity up to the red channel intensity
    						}
    						if(blueTemp *  scaleFactorB > 255){  // check for going over max pixel intensity
    							bluePixels[j] = (byte)255;   // the max value
    						}
    						else{
    							bluePixels[j] =(byte) (blueTemp *  scaleFactorB);  //bring the green channel intensity up to the red channel intensity
    						}
    					}
    				}
    				if(totalGreen > totalBlue && totalGreen > totalRed){
    					
    					double scaleFactorR =  totalGreen / totalRed;
    					double scaleFactorB =  totalGreen / totalBlue;
    					for (int j=0; j<redPixels.length; j++){
    						int redTemp = redPixels[j] & 0xFF;
    						int blueTemp = bluePixels[j] & 0xFF;
    						if(redTemp *  scaleFactorR > 255){  // check for going over max pixel intensity
    							redPixels[j] = (byte)255;   // the max value
    						}
    						else{
    							redPixels[j] =(byte) (redTemp *  scaleFactorR);  //bring the green channel intensity up to the red channel intensity
    						}
    						if(blueTemp *  scaleFactorB > 255){  // check for going over max pixel intensity
    							bluePixels[j] = (byte)255;   // the max value
    						}
    						else{
    							bluePixels[j] =(byte) (blueTemp *  scaleFactorB);  //bring the green channel intensity up to the red channel intensity
    						}
    					}
    				}
    				if(totalBlue > totalGreen && totalBlue > totalRed){
						
						double scaleFactorG =  totalBlue / totalGreen;
						double scaleFactorR =  totalBlue  / totalRed;
						for (int j=0; j<redPixels.length; j++){
							int greenTemp = greenPixels[j] & 0xFF;
							int redTemp = redPixels[j] & 0xFF;
							if(greenTemp *  scaleFactorG > 255){  // check for going over max pixel intensity
								greenPixels[j] = (byte)255;   // the max value
							}
							else{
								greenPixels[j] =(byte) (greenTemp *  scaleFactorG);  //bring the green channel intensity up to the red channel intensity
							}
							if(redTemp *  scaleFactorR > 255){  // check for going over max pixel intensity
								redPixels[j] = (byte)255;   // the max value
							}
							else{
								redPixels[j] =(byte) (redTemp *  scaleFactorR);  //bring the green channel intensity up to the red channel intensity
							}
						}
					}
    				if (totalRed == totalGreen && totalRed == totalBlue){
    					instructions.setText("No intensity equalisation needed");
    				}
    			}
	    		if(RGBmode == SUBTRACTION){//subtratcion algorithm
	    			if(_1_and_2.isSelected()){
			    		for (int j=0; j<redPixels.length; j++){
			    			byte redV = redPixels[j];
			    			byte greenV = greenPixels[j];
			    			
			    			redPixels[j] = (byte)((redV - greenV)*2); //subtracting two channels
			    			if(redPixels[j]< 0){   // is the pixel value less than zero
			    				redPixels[j] = (byte)((255-redPixels[j])*2);  //invert
			    			}
			    			greenPixels[j] = 0;
			    			bluePixels[j] = 0;
			    		}
	    			}
	    			if(_1_and_3.isSelected()){
			    		for (int j=0; j<redPixels.length; j++){
			    			byte redV = redPixels[j];
			    			byte blueV = bluePixels[j];;
			    			
			    			redPixels[j] = (byte)((redV - blueV)*2); //subtracting two channels
			    			if(redPixels[j]< 0){   // is the pixel value less than zero
			    				redPixels[j] = (byte)((255-redPixels[j])*2);  //invert and  times by 2
			    			}
			    			greenPixels[j] = 0;
			    			bluePixels[j] = 0;
			    		}
	    			}
	    		}
	    		
	    		//for (int j=0; j<redPixels.length; j++){
				//	redPixels[j] = (byte)test; 
				//	greenPixels[j] = 0;    
				//	test +=30;
				//}
	    		if(!showRedStack){
	    			redPixels = blank;
	    		}
	    		if(!showGreenStack){
	    			greenPixels = blank;
	    		}
	    		if(!showBlueStack){
	    			bluePixels = blank;
	    		}
	    		cp.setRGB(redPixels, greenPixels, bluePixels);
	    		//byte[] calc = for x < w  
	    			
	    		//cp.set
			if (keep) {
				slice++;
	    			
			} else {
	    			if (red!=null) red.deleteSlice(1);
				if (green!=null &&green!=red) green.deleteSlice(1);
				if (blue!=null&&blue!=red && blue!=green) blue.deleteSlice(1);
			}
			rgb.addSlice(null, cp);
			if ((i%inc) == 0)
				IJ.showProgress((double)i/d);
	    	}
		IJ.showProgress(1.0);
		} catch(OutOfMemoryError o) {
			JOptionPane.showMessageDialog(main_Plugin_Window,"OutOfMemoryError, please restart the plugin");
			IJ.showProgress(1.0);
		}
		//rgb.setRoi(new Rectangle(10,10,10,10));
		return rgb;
	}
	// these methods store the settings that varius programe states will have
	// it prevents users doing things that will cause the programe to do
	// errors, like ask it to copy three images when a 2 way image splitter
	// is used
	
	public void defultButtonSettings(){
		 channelIntensityEqualisation.setSelected(true);  //this is recommended mode
		 channelIntensityEqualisation.addItemListener(new ItemListener(){   //add listener here to avoid listener being called
			 public void itemStateChanged(ItemEvent e){
				 if(programState != OPEN_ALIGNMENT_PROGRAM_STATE)
					 radioButton_and_profiler_Methods();
			 }
		 });
		 BatchSave1st.setSelected(true);
		 BatchSave2nd.setSelected(true);
		 BatchSave3rd.setSelected(true);
		 BatchSaveRGB.setSelected(true);
		 
		 _1_and_2.setSelected(true);
		 _1_and_3.setEnabled(false);
		 if(segmentedColorChannels.isSelected()){
			 _1_and_2.setEnabled(false); 
		 }
		copyButton.setEnabled(true);
		OKButton.setEnabled(false);
		resetButton.setEnabled(false);
		saveButton.setEnabled(false);
		openButton.setEnabled(true);
		northButton.setEnabled(false);
		northButton10.setEnabled(false);
		eastButton.setEnabled(false);
		eastButton10.setEnabled(false);
		southButton.setEnabled(false);
		southButton10.setEnabled(false);
		westButton.setEnabled(false);
		westButton10.setEnabled(false);
		profilerC.setEnabled(false);
		Last_ImageSpliter_Type();
		TwoSplitButton.setEnabled(true);
		ThreeSplitButton.setEnabled(true);
		disableRGBPanel();
		}
	
	public void set_Last_ImageSpliter_Type(){
		try{
			FileOutputStream fos = new FileOutputStream("Last_splitMode.tmp");
			ObjectOutputStream oos = new ObjectOutputStream(fos);
	
			oos.writeObject(r1);
        	oos.writeObject(r2);
        	//don't right is threeSPlit
        	if(r3 != null){
        		oos.writeObject(r2);
        	}
        	//oos.writeObject(new Date());

        	oos.close();
		}
		catch(IOException ee){
			JOptionPane.showMessageDialog(main_Plugin_Window,"Something went wrong with setting last Image spliter type");
		}
	}
	
	public void Last_ImageSpliter_Type(){
		//not used
	}
	
	public void defultSettingsUponReset(){
		defultButtonSettings();
		initialiseVariables();
		testSplitMode();
		closePluginImages();
		if(color != null){
			setColorGrey();
		}
		if(rgbProfiler != null){
			rgbProfiler.closePlotWindows();
		}
	}
	
	public void closePluginImages(){
		//closes all the image windows generated in the plugin except the original one
		//the user opened
		
			try{
			WindowManager.getImage(leftImageID).close();
			}
			catch(Exception e){	}
			try{
				WindowManager.getImage(rightImageID).close();
				}
			catch(Exception e){	}
			try{
				WindowManager.getImage(thirdImageID).close();
				}
			catch(Exception e){	}
			try{
				WindowManager.getImage(rgbID).close();
					}
			catch(Exception e){	}
			try{
				WindowManager.getImage(stackrgbID).close();
					}
			catch(Exception e){	}
			
	}
	
	public	void initialiseVariables(){
		programState = DEFULT_PROGRAM_STATE;
		copyCount = -1;
		//prevents us getting a null pointer exception in the process stacks method
		hasFirstRGBbeenShown = false;
		isRGBOptionsActivated = false;
		showRedStack = true;
		showGreenStack = true;
		showBlueStack = true;
		nudgeRedStack = false;
		nudgeGreenStack = false;
		nudgeBlueStack = false;
		if(isFirstRun){
			RGBmode = SEGMENTED;  //defult for now
		}
		stopChannelIntensityEqualisation = true;
		twoAligned = false;
		threeAligned = false;
		errorFound = false;
		artDataFailed = false;
		isFirstRun = false;
		isForProcessBatch = false;
		profilerActivated = false;
		likesProfiler = false;
		//used because the user might go back to using 2 split,
		//if not, its still ok because he can create rectangle r3 again
		 r3 = null;
	}
	
	
	public String _1stChannelName(String title){
	
		int dotIndex = title.lastIndexOf(".");
		if (dotIndex>=0){
			String original = title.substring(0, dotIndex);
			String fileExtension = title.substring(dotIndex);
			return original + " Channel 1" + fileExtension;
		}
		else{
			return title;   // just in case the image has no file extension
		}
		
	}
	
	public String _2ndChannelName(String title){
		
		int dotIndex = title.lastIndexOf(".");
		if (dotIndex>=0){
			String original = title.substring(0, dotIndex);
			String fileExtension = title.substring(dotIndex);
			return original + " Channel 2" + fileExtension;
		}
		else{
			return title;
		}
	}
	
	public String _3rdChannelName(String title){
		
		int dotIndex = title.lastIndexOf(".");
		if (dotIndex>=0){
			String original = title.substring(0, dotIndex);
			String fileExtension = title.substring(dotIndex);
			return original + " Channel 3" + fileExtension;
		}
		else{
			return title;
		}
	}
	
	public String RGBChannelName(String title){
		
		int dotIndex = title.lastIndexOf(".");
		if (dotIndex>=0){
			String original = title.substring(0, dotIndex);
			String fileExtension = title.substring(dotIndex);
			return original + " RGB" + fileExtension;
	}
		else{
			return title;
		}
	}
	
	//program remembers last split setting mode, stores this on hard drive
	public void rememberToMakeDefultSplitMode(){
//		save something onto the hrad drive so that program can tell if it had been run before
		try{
			FileOutputStream fos = new FileOutputStream("Use_2_way_split_settings.tmp");
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(new String("this file lets the program know to use 2 split"));

			oos.close();
		}
		catch(IOException ee){
		}
	}
	
	public void rememberToMakeTripleSplitMode(){
//		save something onto the hard drive for the program to use later
		try{
			FileOutputStream fos = new FileOutputStream("Use_3_way_split_settings.tmp");
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(new String("this file lets the program know to use 3 split"));

			oos.close();
		}
		catch(IOException ee){
		}
	}
	
	// this checks whether we are set up for a 2 way split or 3 way split
	public void testSplitMode(){
		try{
			FileInputStream fis = new FileInputStream("Use_2_way_split_settings.tmp");
			ObjectInputStream ois = new ObjectInputStream(fis);
			try{
				File file = new File("Use_3_way_split_settings.tmp");
				file.delete();
				
			}
			catch(Exception e){}
			
			ois.close();
			defaultSplitMode();
			return;
		}
		catch(Exception ee){}
		try{
			FileInputStream fis = new FileInputStream("Use_3_way_split_settings.tmp");
			ObjectInputStream ois = new ObjectInputStream(fis);
			try{
				File file = new File("Use_2_way_split_settings.tmp");
				file.delete();
				
			}
			catch(Exception e){}
			
			ois.close();
			tripleSplitMode();
			return;
		}
		catch(IOException e){}
		//nothing there so make default split settings anyway
		defaultSplitMode();
	}
	
	public void defaultSplitMode(){
		//for this plugin the defult is a two split, but this can be changed later
		isTwoSplit = true;
		isThreeSplit = false;
		_1_and_3.setEnabled(false);
		TwoSplitButton.setSelected(true);
		channelSubtraction.setEnabled(true);
		rememberToMakeDefultSplitMode();
		r3 = null;
	}

	//settings for the buttons at a particular time in the program
	public void tripleSplitMode(){
		isTwoSplit = false;
		isThreeSplit = true;
		ThreeSplitButton.setSelected(true);
		segmentedColorChannels.setSelected(true);  //go back to segmented mode because this does not work with three channels yet
		segmentedColorChannels.doClick();
		rememberToMakeTripleSplitMode();
		_1_and_3.setEnabled(false);
		try{
			File file = new File("Use_2_way_split_settings.tmp");
			file.delete();
			
		}
		catch(Exception e){}
	}

	//settings for the buttons at a particular time in the program
	public void buttonsAfterFirstCrop(){
		resetButton.setEnabled(true);
		TwoSplitButton.setEnabled(false);
		ThreeSplitButton.setEnabled(false);
		openButton.setEnabled(false);
	}
	
	public void buttonsAfterSecondCrop(){
		northButton.setEnabled(true);
		northButton10.setEnabled(true);
		eastButton.setEnabled(true);
		eastButton10.setEnabled(true);
		southButton.setEnabled(true);
		southButton10.setEnabled(true);
		westButton.setEnabled(true);
		westButton10.setEnabled(true);
		OKButton.setEnabled(true);
		if(isTwoSplit){
			copyButton.setEnabled(false);
		}
		//leave blank for now
		else if(isThreeSplit){	
			//prevents copybutton being pressed until OKbutton pressed
			//this is so the user can align his second Roi
			copyButton.setEnabled(false);
		}
		redRB.setEnabled(true);
		greenRB.setEnabled(true);
		redC.setEnabled(true);
		greenC.setEnabled(true);
		profilerC.setEnabled(true);
		if(copyCount == 2){
			blueRB.setEnabled(true);
			blueRB.setSelected(true);
			blueC.setEnabled(true);
			blueC.setSelected(true);
		}
		
	}
	
	//called each time a checkbox is activated
	public void checkBoxMethods(){
		if(isTwoSplit || copyCount == ONE_IMAGE_CROPPED){
			processStacks();
			if(profilerActivated){
				rgbProfiler.updateProfile();
			}
		}
		else{
			processTripleStacks();
			if(profilerActivated){
				rgbProfiler.updateProfile();
			}
		}
	}
	
	public void radioButton_and_profiler_Methods(){
		//don't want processTriple to be activated if 2 images have been selected
		if(isThreeSplit && copyCount != 1){
			processTripleStacks();
			if(profilerActivated){
				rgbProfiler.creatergb();
				rgbProfiler.updateProfile();
			}
		}
		else{
			processStacks();
			if(profilerActivated){
				rgbProfiler.creatergb();
				rgbProfiler.updateProfile();
			}
		}
		
	}

	//setting for the buttons at a particular time in the program
	public void disableRGBPanel(){
		redRB.setEnabled(false);
		greenRB.setEnabled(false);
		blueRB.setEnabled(false);
		redC.setEnabled(false);
		greenC.setEnabled(false);
		blueC.setEnabled(false);
		profilerC.setEnabled(false);
		if(profilerActivated){
			rgbProfiler.closePlotWindows();
		}
		
	}
//	setting for the buttons at a particular time in the program
	public void enableRGBPanel(){
		redRB.setEnabled(true);
		greenRB.setEnabled(true);
		blueRB.setEnabled(true);
		redC.setEnabled(true);
		greenC.setEnabled(true);
		blueC.setEnabled(true);
		profilerC.setEnabled(true);
		if(profilerActivated){
			rgbProfiler.creatergb();
			rgbProfiler.updateProfile();
		}
	}
	
	//setting for the buttons at a particular time in the program
	public void buttonsAfterOK(){
		northButton.setEnabled(false);
		northButton10.setEnabled(false);
		eastButton.setEnabled(false);
		eastButton10.setEnabled(false);
		southButton.setEnabled(false);
		southButton10.setEnabled(false);
		westButton.setEnabled(false);
		westButton10.setEnabled(false);
		if(isTwoSplit){
			copyButton.setEnabled(false);
			saveButton.setEnabled(true);
			OKButton.setEnabled(false);
		}
		else if(isThreeSplit && copyCount == ONE_IMAGE_CROPPED){	
			copyButton.setEnabled(true);
			saveButton.setEnabled(false);
			OKButton.setEnabled(false);
		}
		else if(isThreeSplit && copyCount == TWO_IMAGES_CROPPED){	
			copyButton.setEnabled(false);
			saveButton.setEnabled(false);
			OKButton.setEnabled(false);
		}
	}
	
	/**
	 * load the artwork used in the GUI. Two different imports depending on whether the plugin is run in 
	 * eclipse or imageJ
	 */
	public void getArtData(){
		URL url = null;
		  try {
//			this image import used when running in jar file  
		       
		  
		            url = getClass().getResource( "/Resources/cairn.jpg");
		            Image image = Toolkit.getDefaultToolkit().getImage(url);    
		            cairnIcon = new ImageIcon(image);
		            url = getClass().getResource("/Resources/up.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  northIcon = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/up.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  northIcon10 = new ImageIcon(image);
			      	  url = getClass().getResource("/Resources/right.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  eastIcon = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/right.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  eastIcon10 = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/down.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  southIcon = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/down.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  southIcon10 = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/left.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  westIcon = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/left.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  westIcon10 = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/red.jpg");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  redIcon = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/green.jpg");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  greenIcon = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/blue.jpg");
		            image = Toolkit.getDefaultToolkit().getImage(url);
			      	  blueIcon = new ImageIcon(image);
			      	url = getClass().getResource("/Resources/grey.jpg");
		            image = Toolkit.getDefaultToolkit().getImage(url);
				   	  greyIcon = new ImageIcon(image);
				   	url = getClass().getResource("/Resources/graphics_showgraph.gif");
		            image = Toolkit.getDefaultToolkit().getImage(url);
				   	  showgraph = new ImageIcon(image);	 
				   	  
				   	url = getClass().getResource("/Resources/ROI.jpg");
		            image = Toolkit.getDefaultToolkit().getImage(url);
				   	 align = new ImageIcon(image);	
				   	
				   	  	 
				   	  
				//this image import used when running in eclipse   	  
		      
			/*	   	  
			  cairnIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "cairn.jpg")));
	      	  northIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "up.gif")));
	      	  northIcon10 = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "up.gif")));
	      	  eastIcon = new ImageIcon(ImageIO.read(new File(currDir+ "Resources" + File.separator + "right.gif")));
	      	  eastIcon10 = new ImageIcon(ImageIO.read(new File(currDir+ "Resources" + File.separator + "right.gif")));
	      	  southIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "down.gif")));
	      	  southIcon10 = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "down.gif")));
	      	  westIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "left.gif")));
	      	  westIcon10 = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "left.gif")));
	      	  redIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "red.jpg")));
	      	  greenIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "green.jpg")));
	      	  blueIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "blue.jpg")));
		   	  greyIcon = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "grey.jpg")));
		   	  showgraph = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "graphics_showgraph.gif")));	   
		   	  align = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "ROI.jpg")));
		   	  optosplit = new ImageIcon(ImageIO.read(new File(currDir + "Resources" + File.separator + "optosplit.jpg")));
		   	 */
//		   	loads the colored circle image from the hard drive;
				setColorGrey();
	        
	      	  
		}
	        catch(NullPointerException e) {
	        	JOptionPane.showMessageDialog(main_Plugin_Window,"No image open!");
	        }
		 catch(Exception e) {
			// IJ.showMessage("Plugin will work fine although GUI graphics have failed to load"); 
			     
			artDataFailed = true;
			//		use text instead of grtaphics
			  cairnButton = new JButton(" Cairn Website");
	      	  northButton = new JButton("North");
	      	  northButton10 = new JButton("North +10");
	      	  eastButton= new JButton("East");
	      	  eastButton10 = new JButton("East +10");
	      	  southButton = new JButton("South");
	      	  southButton10 = new JButton("South +10");
	      	  westButton= new JButton("West");
	      	  westButton10 = new JButton("West +10");
	      	profilerLabel = new JLabel("Active Profiler");
	      	  //the progam can't use this because images failed to load
			 color = null;
		 } 
	}
	
	public void setColorGrey(){
		try{
			if (color == null){
				color = new JLabel(greyIcon);
			}
			else{
				color.setIcon(greyIcon);
			}
		}
		catch(Exception e) {}
	}
	
	public void setColorRed(){
		try{
			color.setIcon(redIcon);
		}
		catch(Exception e) {}
	}
	
	public void setColorGreen(){
		try{
			color.setIcon(greenIcon);
		}
		catch(Exception e) {}
	}
	
	public void setColorBlue(){
		try{
			color.setIcon(blueIcon);
		}
		catch(Exception e) {}
	}
	
	
	public void isFirstProgramRun(){
		try{
			FileInputStream fis = new FileInputStream("hasRunBefore.tmp");
			ObjectInputStream ois = new ObjectInputStream(fis);
			ois.close();
		}
		// nothing there so we know this is the first run
		catch(IOException ee){
			isFirstRun = true;
			setHasRunBefore();
			
		//	JOptionPane.showMessageDialog(main_Plugin_Window,aboutText,"Intro",JOptionPane.INFORMATION_MESSAGE,optosplit);
			 
			//this message will only be displayed the first time round
			JOptionPane.showMessageDialog(main_Plugin_Window,"Welcome to the Image splitter plugin by Cairn Research\n" +
					"We hope that this provides the tools necessary for your Image analysis\n" +
					"and that you find the software easy to use\n" +
					"Please follow the directions on the plugin \n" +
					"User feedback is most welcome.","Intro",JOptionPane.INFORMATION_MESSAGE);
		}
	}
	

	/** This is the place to add code to process each image in a certain way. The image 
		is not written if this method returns null. This method is unimplemented for now */
	public ImagePlus process(ImagePlus img) {
		//double xscale = 1.6;
		//double yscale = 1.1;
		//int width = img.getWidth();
		//int height = img.getHeight();
		//ImageProcessor ip = img.getProcessor();
		//ip.setInterpolate(true);
		//ip = ip.resize((int)(width*xscale), (int)(height*yscale));
		//img.setProcessor(null, ip);
		return img;
	}

	
	public void setHasRunBefore(){
		//save something onto the hrad drive so that program can tell if it had been run before
		try{
			FileOutputStream fos = new FileOutputStream("hasRunBefore.tmp");
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(new String("this file lets the program know that it has run before"));

			oos.close();
		}
		catch(IOException ee){
		}
	}
	
	
	/////////////////////////////////////////////////////////////
	
	
	
	
	//BATCH ANALYSER STUFF
	
	
	
	
	
	//////////////////////////////////////
	
	
	
	
	/*
	 * Test method to speed up debugging process
	 */
	public void test_start_Batch_Analyser(){
		boolean last2split = isTwoSplit;
		boolean last3split = isThreeSplit;
		isForProcessBatch = true;
		String dir1 = "";
		String dir2 = "";
		dir1 = "C:/Documents and Settings/nkatsikanis/Desktop/btest/";
		

	
		
		  dir2 =  "C:/Documents and Settings/nkatsikanis/Desktop/btestgo/";
			
		
		//format = gd.getNextChoice();
	
		
		
		     File file = new File("C:/Documents and Settings/nkatsikanis/Desktop/align2");
		        
		        try{
					FileInputStream fis = new FileInputStream(file);
					ObjectInputStream ois = new ObjectInputStream(fis);
					r1 = (Rectangle) ois.readObject();
					r2 = (Rectangle) ois.readObject();
				
					try{
						r3 = (Rectangle) ois.readObject();
						isTwoSplit = false;
						isThreeSplit = true;
					}
					catch(Exception e){
						System.out.println("no rectangle 3");
						isTwoSplit = true;
						isThreeSplit = false;
					}
		        }
		        catch(Exception e){
		        	IJ.showMessage("Batch Analyser failed.");
		        }
				
				//wane rasbands method of iterating through a directory
				IJ.log("");
				//IJ.log("Converting to "+format);
				IJ.log("Splitting according to selected alignment");
				if (!dir2.endsWith(File.separator))
					dir2 += File.separator;
				IJ.log("dir1: "+dir1);
				IJ.log("dir2: "+dir2);
				String[] list = new File(dir1).list();
				if (list==null) return;
				for (int i=0; i<list.length; i++) {
					IJ.log((i+1)+": "+list[i]);
					IJ.showStatus(i+"/"+list.length);
					File f = new File(dir1+list[i]);
					if (!f.isDirectory()) {
						Bimg = new Opener().openImage(dir1, list[i]);
						if (Bimg!=null) {
						//	firstImageID = Bimg.getID(); //now my code to process the current opend image
							//if (img!=null)
							//	save(img, dir2, format);
						}
					}
//					set up the booleans so that the method processStacks() works
					 
					//although already aligned this is false to let the programe wait
					//until any RGB intensity modifications are done
					twoAligned = false;
					
					//assumes no combined image has been shown yet
					hasFirstRGBbeenShown =false;
					//get rid of previous images
					closePluginImages();
					//need to repeat because of the construction of the processStacks method
					if(isTwoSplit){
						processStacksForBatch();
						twoAligned = true;
						if(!errorFound){
							processStacksForBatch();
							if(BatchSave1st.isSelected())
								saveBatch(batchImages[0],dir2,format);
							if(BatchSave2nd.isSelected())
								saveBatch(batchImages[1],dir2,format);
							if(BatchSaveRGB.isSelected())                  //dont need batchImages[2]
								saveBatch(batchImages[3],dir2,format);
						}
						
					}
					else if(isThreeSplit){
						processStacksForBatch();
						// go straight to process whole stack mode
						threeAligned = true;
						processTripleStacksForBatch();
						if(BatchSave1st.isSelected())
							saveBatch(batchImages[0],dir2,format);
						if(BatchSave2nd.isSelected())
							saveBatch(batchImages[1],dir2,format);
						if(BatchSave3rd.isSelected())
							saveBatch(batchImages[2],dir2,format);
						if(BatchSaveRGB.isSelected())               
							saveBatch(batchImages[3],dir2,format);
					}
					
				}
				//make sure this is defult after reaching here
				errorFound = false;
				copyButton.setEnabled(false);
				
				
				resetButton.setEnabled(true);
				IJ.showProgress(1.0);
				IJ.showStatus("");
				
				
				
			
	
				
			
	
		
		 isTwoSplit =last2split;  //restore the origninals
		 isThreeSplit =last3split;
		 r3 = null;
		

		//convert(dir1, dir2, format);
	}
	
	/*
	public void test_start_Batch_Analyser(){
		isForProcessBatch = true;
		String dir1;
		String dir2;
		// new BatchAnalyser();
		//OpenDialog od = new OpenDialog("Select a file in source folder...", "");
		//if (od.getFileName()==null) {
		//	return;
		//}
		//dir1 = od.getDirectory();
		dir1 = "C:/Documents and Settings/nkatsikanis/Desktop/btest/";
		

		//GenericDialog gd = new GenericDialog("Batch Converter", IJ.getInstance());
		//gd.addChoice("Save split images as ", choices, format);
		//gd.showDialog();
		//if (gd.wasCanceled())
		//	return;
		//format = gd.getNextChoice();
		
		//SaveDialog sd = new SaveDialog("Open destination folder...", "dummy name (required)", "");
		//if (sd.getFileName()==null){
		///}
	    dir2 =  "C:/Documents and Settings/nkatsikanis/Desktop/btestgo/";
		
		//format = gd.getNextChoice();
	
		
		try{
			//fc.setDialogTitle("Choose your alignment, your alignment must have been made with an image of the same size as your images in the source folder");
	        //int returnVal = fc.showOpenDialog(null);

	        //if (returnVal == JFileChooser.APPROVE_OPTION) {
	            File file = new File("C:/Documents and Settings/nkatsikanis/Desktop/align");
	            //String dir1 = file.getPath();
	        
				FileInputStream fis = new FileInputStream(file);
				ObjectInputStream ois = new ObjectInputStream(fis);
				try{
					r1 = (Rectangle) ois.readObject();
					r2 = (Rectangle) ois.readObject();
					if(isThreeSplit){
						r3 = (Rectangle) ois.readObject();
					}
					ois.close();
				}
				catch(ClassNotFoundException cnf){
					IJ.error("ClassNotFoundException");
				}
				
				//wane rasbands method of iterating through a directory
				IJ.log("");
				//IJ.log("Converting to "+format);
				IJ.log("Splitting according to selected alignment");
				if (!dir2.endsWith(File.separator))
					dir2 += File.separator;
				IJ.log("dir1: "+dir1);
				IJ.log("dir2: "+dir2);
				String[] list = new File(dir1).list();
				if (list==null) return;
				for (int i=0; i<list.length; i++) {
					IJ.log((i+1)+": "+list[i]);
					IJ.showStatus(i+"/"+list.length);
					File f = new File(dir1+list[i]);
					if (!f.isDirectory()) {
						Bimg = new Opener().openImage(dir1, list[i]);
						if (Bimg!=null) {
						//	firstImageID = Bimg.getID(); //now my code to process the current opend image
							//if (img!=null)
							//	save(img, dir2, format);
						}
					}
//					set up the booleans so that the method processStacks() works
					 
					//although already aligned this is false to let the programe wait
					//until any RGB intensity modifications are done
					twoAligned = false;
					
					//assumes no combined image has been shown yet
					hasFirstRGBbeenShown =false;
					//get rid of previous images
					closePluginImages();
					//need to repeat because of the construction of the processStacks method
					if(isTwoSplit){
						processStacksForBatch();
						twoAligned = true;
						if(!errorFound){
							processStacksForBatch();
							//batchImages[0].setTitle(batchImages[1].getTitle()+"_1st_Channel");
							saveBatch(batchImages[0],dir2,format);
							
							//batchImages[1].setTitle(batchImages[1].getTitle()+"_2nd_Channel");
							saveBatch(batchImages[1],dir2,format);
							saveBatch(batchImages[3],dir2,format);
						}
						
					}
					else if(isThreeSplit){
						processStacks();
						// go straight to process whole stack mode
						threeAligned = true;
						processTripleStacks();
					}
					
				}
				//make sure this is defult after reaching here
				errorFound = false;
				copyButton.setEnabled(false);
				
				
				resetButton.setEnabled(true);
				IJ.showProgress(1.0);
				IJ.showStatus("");
				
				
				
			
	
				
			
		}
		catch(IOException ee){
			IJ.error("Something went wrong with opening");
		}	
		
		
		

		//convert(dir1, dir2, format);
	}
	*/
	
	public void start_Batch_Analyser(){
		instructions.setText("Batch processing commencing.....please wait\n");
		
		//temp booleans
		boolean last2split = isTwoSplit;
		boolean last3split = isThreeSplit;
		boolean lastStopChannelIntensityEqualisation = stopChannelIntensityEqualisation;  
		stopChannelIntensityEqualisation = true;
		
		isForProcessBatch = true;
		String dir1 = "";
		String dir2 = "";
		try{
			fc.setDialogTitle("Select 1st image in source folder...");
	        int returnVal = fc.showOpenDialog(null);
	        if (returnVal == JFileChooser.CANCEL_OPTION) {
	        	instructions.setText("Batch processing canceled");
	        	return;  //don't bother with the rest
	        }
	        if (returnVal == JFileChooser.APPROVE_OPTION) {
	        	 dir1 = fc.getCurrentDirectory().getPath();
	        }
		}
	    catch(Exception e){
	    	System.out.print("open failed");
	    	return;
	    }
		

		GenericDialog gd = new GenericDialog("Batch Converter", IJ.getInstance());
		gd.addChoice("Save split images as ", choices, format);
		gd.showDialog();
		if (gd.wasCanceled())
			return;
		format = gd.getNextChoice();
		
		try{
			String dummy = "dummy name (required)";
			fc.setSelectedFile(new File(dummy));
			fc.setDialogTitle("Select destination folder...");
	        int returnVal = fc.showSaveDialog(null);
	        if (returnVal == JFileChooser.CANCEL_OPTION) {
	        	instructions.setText("Batch processing canceled");
	        	return;  //don't bother with the rest
	        }
	        if (returnVal == JFileChooser.APPROVE_OPTION) {
	        	dir2 = fc.getCurrentDirectory().getPath();
	        }
		}
	    catch(Exception e){
	    	System.out.print("open2 failed");
	    	return;
	    }
		
		//format = gd.getNextChoice();
	
		
		try{
			String empty = "";
			openAlignfc.setSelectedFile(new File(empty));
			openAlignfc.setDialogTitle("Choose your alignment...");
	        int returnVal = openAlignfc.showOpenDialog(null);
	        if (returnVal == JFileChooser.CANCEL_OPTION) {
	        	instructions.setText("Batch processing canceled");
	        	return;  //don't bother with the rest
	        }
	         
	        if (returnVal == JFileChooser.APPROVE_OPTION) {
	            File file = openAlignfc.getSelectedFile();
	            //String dir1 = file.getPath();
		        try{
					FileInputStream fis = new FileInputStream(file);
					ObjectInputStream ois = new ObjectInputStream(fis);
					r1 = (Rectangle) ois.readObject();
					r2 = (Rectangle) ois.readObject();
				
					try{
						r3 = (Rectangle) ois.readObject();
						isTwoSplit = false;
						isThreeSplit = true;
					}
					catch(IOException e){
						System.out.println("no rectangle 3");
						isTwoSplit = true;
						isThreeSplit = false;
					}
		        }
		        catch(ClassNotFoundException e){
		        	instructions.setText("Batch Analyser failed");
		        }
				
				//wane rasbands method of iterating through a directory
				IJ.log("");
				//IJ.log("Converting to "+format);
				IJ.log("Splitting according to selected alignment");
				if (!dir2.endsWith(File.separator))
					dir2 += File.separator;
				IJ.log("dir1: "+dir1);
				IJ.log("dir2: "+dir2);
				String[] list = new File(dir1).list();
				if (list==null) return;
				
				for (int i=0; i<list.length; i++) {
					
					File f = new File(dir1+list[i]);
					String exten = AlignmentFilter.getExtension(f);
					//if(exten != "tif" && exten !=  "jpg" && exten !=  "gif" || exten == "ali"){
					//	break;
					//}
					IJ.log((i+1)+": "+list[i]);
					IJ.showStatus(i+"/"+list.length);
					if (!f.isDirectory()) {
						Bimg = new Opener().openImage(dir1, list[i]);
						if (Bimg!=null) {
						//	firstImageID = Bimg.getID(); //now my code to process the current opend image
							//if (img!=null)
							//	save(img, dir2, format);
						}
					}
//					set up the booleans so that the method processStacks() works
					 
					//although already aligned this is false to let the programe wait
					//until any RGB intensity modifications are done
					twoAligned = false;
					
					//assumes no combined image has been shown yet
					hasFirstRGBbeenShown =false;
					//get rid of previous images
					closePluginImages();
					//need to repeat because of the construction of the processStacks method
					if(isTwoSplit){
						processStacksForBatch();
						twoAligned = true;
						if(!errorFound){
							processStacksForBatch();
							if(BatchSave1st.isSelected())
								saveBatch(batchImages[0],dir2,format);
							if(BatchSave2nd.isSelected())
								saveBatch(batchImages[1],dir2,format);
							if(BatchSaveRGB.isSelected())                  //dont need batchImages[2]
								saveBatch(batchImages[3],dir2,format);
						}
						
					}
					else if(isThreeSplit){
						processStacksForBatch();
						// go straight to process whole stack mode
						threeAligned = true;
						processTripleStacksForBatch();
						if(BatchSave1st.isSelected())
							saveBatch(batchImages[0],dir2,format);
						if(BatchSave2nd.isSelected())
							saveBatch(batchImages[1],dir2,format);
						if(BatchSave3rd.isSelected())
							saveBatch(batchImages[2],dir2,format);
						if(BatchSaveRGB.isSelected())               
							saveBatch(batchImages[3],dir2,format);
					}
					
				}
				instructions.append("\nBatch processing completed successfully");
				//make sure this is defult after reaching here
				errorFound = false;
				copyButton.setEnabled(false);
				
				
				resetButton.setEnabled(true);
				IJ.showProgress(1.0);
				IJ.showStatus("");
				
				
				
			
	
				
			}
		}
		catch(IOException ee){
			IJ.error("Something went wrong with opening");
		}	
		
		 isTwoSplit =last2split;  //restore the origninals to the temps
		 isThreeSplit =last3split;
		 stopChannelIntensityEqualisation = lastStopChannelIntensityEqualisation;  
		 
		 r3 = null;
		

		//convert(dir1, dir2, format);
	}
	
	public void saveBatch(ImagePlus img, String dir, String format) {
		String name = img.getTitle();
		int dotIndex = name.lastIndexOf(".");
		if (dotIndex>=0)
			name = name.substring(0, dotIndex);
		String path = dir + name;
		if (format.equals("Tiff"))
			try{
				new FileSaver(img).saveAsTiff(path+".tif");
			}
			catch(ClassCastException e){
				new FileSaver(img).saveAsTiffStack(path+".tif");
			}
		else if (format.equals("8-bit Tiff"))
			saveAs8bitTiff(img, path+".tif");
		else if (format.equals("Zip"))
			new FileSaver(img).saveAsZip(path+".zip");
		else if (format.equals("Raw"))
			new FileSaver(img).saveAsRaw(path+".raw");
	}
	
	public void convert(String dir1, String dir2) {  //my method
		IJ.log("");
		//IJ.log("Converting to "+format);
		IJ.log("Splitting according to selected alignment");
		if (!dir2.endsWith(File.separator))
			dir2 += File.separator;
		IJ.log("dir1: "+dir1);
		IJ.log("dir2: "+dir2);
		String[] list = new File(dir1).list();
		if (list==null) return;
		for (int i=0; i<list.length; i++) {
			IJ.log((i+1)+": "+list[i]);
			IJ.showStatus(i+"/"+list.length);
			File f = new File(dir1+list[i]);
			if (!f.isDirectory()) {
				ImagePlus img = new Opener().openImage(dir1, list[i]);
				if (img!=null) {
					img = process(img);
					//if (img!=null)
						//save(img, dir2, format);
				}
			}
		}
		IJ.showProgress(1.0);
		IJ.showStatus("");
	}

	

	void saveAs8bitTiff(ImagePlus img, String path) {
		ImageProcessor ip = img.getProcessor();
		if (ip instanceof ColorProcessor)
			{ip = reduceColors(ip); img.setProcessor(null, ip);}
		else if ((ip instanceof ShortProcessor) || (ip instanceof FloatProcessor))
			{ip = ip.convertToByte(true); img.setProcessor(null, ip);}
		try{
			new FileSaver(img).saveAsTiff(path+".tif");
		}
		catch(ClassCastException e){
			new FileSaver(img).saveAsTiffStack(path+".tif");
		}
	}

	ImageProcessor reduceColors(ImageProcessor ip) {
		MedianCut mc = new MedianCut((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
		Image img = mc.convert(256);
		return(new ByteProcessor(img));
	}

	
	
	
	
	//starts the plugin
	public static void main(String[] args)
    {
        new Cairn_Image_Splitter();
    }
	
}

/* ImageFilter.java is based on FileChooserDemo2.java. from http://java.sun.com/docs/books/tutorial/uiswing/components/examples/index.html#FileChooserDemo*/


class AlignmentFilter extends FileFilter {

  //Accept all directories and all gif, jpg, tiff, or png files.
  public boolean accept(File f) {
      if (f.isDirectory()) {
          return true;
      }

      String extension = getExtension(f);
      if (extension != null) {
          if (extension.equals("ali") ||
              extension.equals("ALI")) {
                  return true;
          } else {
              return false;
          }
      }

      return false;
  }

  //The description of this filter
  public String getDescription() {
      return "Alignment files";
  }
  
  public static String getExtension(File f) {
      String ext = null;
      String s = f.getName();
      int i = s.lastIndexOf('.');

      if (i > 0 &&  i < s.length() - 1) {
          ext = s.substring(i+1).toLowerCase();
      }
      return ext;
  }
  
}
/* ImageFileView.java is based on FileChooserDemo2.java. from http://java.sun.com/docs/books/tutorial/uiswing/components/examples/index.html#FileChooserDemo*/


 class AlignmentFileView extends FileView {
	 Icon iconAli;
	 public AlignmentFileView(Icon icon){
		 this.iconAli = icon;
	 }
	 
    public String getName(File f) {
        return null; //let the L&F FileView figure this out
    }

    public String getDescription(File f) {
        return null; //let the L&F FileView figure this out
    }

    public Boolean isTraversable(File f) {
        return null; //let the L&F FileView figure this out
    }

    public String getTypeDescription(File f) {
        String extension = AlignmentFilter.getExtension(f);
        String type = null;

        if (extension != null) {
            if (extension.equals("ali") ||
                extension.equals("ALI")) {
                type = "ali file";
            }
        }
        return type;
    }

    public Icon getIcon(File f) {
        String extension = AlignmentFilter.getExtension(f);
        Icon icon = null;

        if (extension != null) {
            if (extension.equals("ali") ||
                extension.equals("ALI")) {
                icon = iconAli;
                return icon;
            }
        }
        return icon;
    }
 }

