
 
import ij.*;
import ij.plugin.filter.PlugInFilter;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import java.awt.event.*;
	

    public class RGBprofiler implements PlugInFilter, MouseListener, MouseMotionListener, KeyListener {
        int mouseX;  // for when the user moves the rgb cursor in the plugin
        int mouseY;
        boolean initial = true; //is it the first time this class has been asked to update profile
        boolean hasMouseEvent = false;// has a mouse been used yet to update point Roi in RGB window
        //used in setting window locations
   	 static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
   	 static final int SPLITS_FROM_BOTTOM = 25;
    	
    	ImagePlus img,imred,imgreen,imblue;
        ImageCanvas canvas;
        ImagePlus plotImage;
        ImagePlus plotImage2;
        int horizontal_profileID;
    	int vertical_profileID;
        
    public int setup(String arg, ImagePlus img) {
         if (IJ.versionLessThan("1.31i"))
            return DONE;
        this.img = img;
        IJ.register(RGBprofiler.class);
        if (!isSelection()) {
            // IJ.showMessage("RGB_Profiler", "The RGB image requires a point selection. Point selections\n" +
            // 		"are available in the toolbar on the main ImageJ panel");
             return DONE;
        } else
            return DOES_ALL+NO_CHANGES;
    }

    public void run(ImageProcessor ip) {
        if (img.getType()!=ImagePlus.COLOR_RGB) {
            IJ.showMessage("", "image must be color RGB");
            return;
        }
        ImageWindow win = img.getWindow();
        canvas = win.getCanvas();
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addKeyListener(this);
        creatergb();
        updateProfile();
    }

  
    public void keyReleased(KeyEvent e) {
       // updateProfile();
    }

    void creatergb(){
	int lon,lar,x,y;
	ImageProcessor ip1,ipred,ipgreen,ipblue;
	ip1= img.getProcessor();
	lon = img.getWidth();
	lar = img.getHeight();
	//images in memory for processing internaly 
	imred = NewImage.createFloatImage("red",lon,lar,1,NewImage.FILL_BLACK); //init each image blank
	imblue = NewImage.createFloatImage("blue",lon,lar,1,NewImage.FILL_BLACK);
	imgreen = NewImage.createFloatImage("green",lon,lar,1,NewImage.FILL_BLACK);
	ipred = imred.getProcessor();
	ipblue = imblue.getProcessor();
	ipgreen = imgreen.getProcessor();
	int[] pixels = (int[])ip1.getPixels();
	for (y=0; y<lar; y++) {
                for (x=0; x<lon; x++) {
                    int pos = y*lon +x;
		    int c = pixels[pos];
		    int red =(c&0xff0000)>>16;  //and out the different color components
		    int green =(c&0x00ff00)>>8;
		    int blue =(c&0x0000ff);
		    ipred.putPixelValue(x,y,red);
		    ipblue.putPixelValue(x,y,blue);
		    ipgreen.putPixelValue(x,y,green);
		}
	}
    }
    
    void updateProfile() {
         if (!isSelection())
             return;
         checkPlotWindow();
	// my own code 
     int width = imred.getWidth();
     int height = imred.getHeight(); 
     
     
     //init here just incase the PointRoi in the next few lines doesn't work
     int xPos = width/2;
	 int yPos = height/2;
	 if(hasMouseEvent){
		 xPos = mouseX;  // asign the coords from our mouse movements
		 yPos = mouseY;
	 }
	 
     //do the x axis profile
	 Line sel = new Line(0,yPos, width, yPos);
	 imred.setRoi(sel);
	 double[] yred,ygreen,yblue;
         ProfilePlot profile = new ProfilePlot(imred); //a class that imageJ has for convientiantly profiles
         yred = profile.getProfile();
         if (yred==null || yred.length==0)
             return;
	 imblue.setRoi(sel);
         profile = new ProfilePlot(imblue);
         yblue = profile.getProfile();
         if (yblue==null || yblue.length==0)
             return;
	 imgreen.setRoi(sel);
         profile = new ProfilePlot(imgreen);
         ygreen = profile.getProfile();
         if (ygreen==null || ygreen.length==0)
             return;
         int n = yred.length;
         double[] x = new double[n];
         for (int i=0; i<n; i++)
             x[i] = i;
         Plot plot = new Plot("Horizontal Profile", "Distance","Value", x, yred);	 

	 plot.setLimits(0,n-1,0,256);
	 plot.setColor(java.awt.Color.blue);  //assign different colors for each channel from the image spliter
	 plot.addPoints(x,yblue,2);
	 plot.setColor(java.awt.Color.green);
	 plot.addPoints(x,ygreen,2);
	 plot.setColor(java.awt.Color.red);
	 
         ImageProcessor ip = plot.getProcessor();
         if (plotImage==null) {
             plotImage = new ImagePlus("Horizontal Profile", ip);
             plotImage.show();
   		 int h = plotImage.getWindow().getHeight();
   		plotImage.getWindow().setLocation(0, screenSize.height - h - SPLITS_FROM_BOTTOM);
              horizontal_profileID = plotImage.getID();
        }
        plotImage.setProcessor(null, ip);
        
        
        
        //do the y axis profile
         sel = new Line(xPos,0, xPos, height);
        imred.setRoi(sel);
   	 
            ProfilePlot profile2 = new ProfilePlot(imred);
            yred = profile2.getProfile();
            if (yred==null || yred.length==0)
                return;
   	 imblue.setRoi(sel);
            profile2 = new ProfilePlot(imblue);
            yblue = profile2.getProfile();
            if (yblue==null || yblue.length==0)
                return;
   	 imgreen.setRoi(sel);
            profile2 = new ProfilePlot(imgreen);
            ygreen = profile2.getProfile();
            if (ygreen==null || ygreen.length==0)
                return;
             n = yred.length;
             x = new double[n];
            for (int i=0; i<n; i++)
                x[i] = i;
             Plot plot2 = new Plot("Vertical Profile", "Distance","Value", x, yred);	 

   	 plot2.setLimits(0,n-1,0,256);
   	 plot2.setColor(java.awt.Color.blue);
   	 plot2.addPoints(x,yblue,2);
   	 plot2.setColor(java.awt.Color.green);
   	 plot2.addPoints(x,ygreen,2);
   	 plot2.setColor(java.awt.Color.red);
   	 
             ip = plot2.getProcessor();
            if (plotImage2==null) {
                plotImage2 = new ImagePlus("Vertical Profile", ip);
                plotImage2.show();
         		int w = plotImage.getWindow().getWidth();
          		 int h = plotImage.getWindow().getHeight();
          		plotImage2.getWindow().setLocation(w, screenSize.height - h - SPLITS_FROM_BOTTOM);
                vertical_profileID = plotImage.getID();
           }
           plotImage2.setProcessor(null, ip);
           //initial = false; //not used 
    }
    
    // method to save user manually closing windows
    public void closePlotWindows(){
    	try{

    		plotImage.close();
    	}
    	catch(Exception e){
    		
    	}
    	try{
    		plotImage2.close();
    	}
    	catch(Exception e){
    		
    	}
    }

    // returns true if there is a line selection
    boolean isSelection() {
        if (img==null)
            return false;
        Roi roi = img.getRoi();
        if (roi==null)
     	   //this will be changed to false when if I figure out how to use point selections
            return true;
        int roiType = roi.getType();
        if (roiType==Roi.POINT )
            return true;
       else
    	   //this will be changed to false when if  I figure out how to use point selections
            return true;
    }

    // stop listening for mouse events if the plot window has been closed
    void checkPlotWindow() {
       if (plotImage==null) 
            return;
       ImageWindow win = plotImage.getWindow();
       if (win==null || win.isVisible()) 
           return;
       win = img.getWindow();
       if (win==null)
           return;
       canvas = win.getCanvas();
       canvas.removeMouseListener(this);
       canvas.removeMouseMotionListener(this);
       canvas.removeKeyListener(this);
   }

    //stuff that has to be wrote because of java interface rules, all methods must be implemented
    //even if they do nothing
    public void mousePressed(MouseEvent e) {}
    public void keyPressed(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {}   
    public void mouseEntered(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}

    public void mouseDragged(MouseEvent e) {  // also update profile windows when mouse dragged
    	if(img.getRoi().getType() == Roi.POINT){
    		hasMouseEvent = true;
    		mouseX = e.getX();
    		mouseY = e.getY();
    		creatergb();
    		updateProfile();
    	}
    }
    
    public void mouseReleased(MouseEvent e) {
    	if(img.getRoi().getType() == Roi.POINT){ //is there a point roi
    		hasMouseEvent = true;
    		mouseX = e.getX();  //get the x coord
    		mouseY = e.getY();
    		creatergb();		// draw the RGB profilers
    		updateProfile();   // update the profilers
    	}
    }
    
}



