/*
 * Decompiled with CFR 0.152.
 */
package com.cairn.multisplit_3;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import org.micromanager.Studio;
import org.micromanager.data.Coords;
import org.micromanager.data.Datastore;
import org.micromanager.data.DatastoreFrozenException;
import org.micromanager.data.DatastoreRewriteException;
import org.micromanager.data.Image;
import org.micromanager.display.DisplaySettings;
import org.micromanager.display.DisplayWindow;

public class MultiProfiler {
    private DisplayWindow window = null;
    private Studio mm;
    private static final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW};

    MultiProfiler(Studio studio, Datastore compositeImage) {
        this.mm = studio;
        this.updatePlot(compositeImage);
    }

    void updatePlot(Datastore compImg) {
        Datastore ds;
        if (compImg == null) {
            return;
        }
        Coords.CoordsBuilder cb = this.mm.data().getCoordsBuilder();
        cb.time(0).z(0).stagePosition(0);
        int numChannels = compImg.getImagesMatching(cb.build()).size();
        Plot horzPlot = null;
        Plot vertPlot = null;
        double maxV = 0.0;
        double maxH = 0.0;
        for (int c = 0; c < numChannels; ++c) {
            cb.channel(c);
            ImageProcessor ip = this.mm.data().ij().createProcessor(compImg.getImage(cb.build()));
            ImagePlus imagePlus = new ImagePlus("" + c, ip);
            imagePlus.setRoi((Roi)new Line(0, ip.getHeight() / 2, ip.getWidth(), ip.getHeight() / 2));
            ProfilePlot horzProf = new ProfilePlot(imagePlus);
            double[] y = horzProf.getProfile();
            double[] x = new double[ip.getWidth()];
            for (int i = 0; i < ip.getWidth(); ++i) {
                x[i] = i;
                if (!(y[i] > maxH)) continue;
                maxH = y[i];
            }
            if (c == 0) {
                horzPlot = new Plot("Horizontal Profile", "Distance", "Value", x, y);
            }
            horzPlot.setColor(colors[c]);
            horzPlot.addPoints(x, y, 2);
            imagePlus.setRoi((Roi)new Line(ip.getWidth() / 2, 0, ip.getWidth() / 2, ip.getHeight()));
            ProfilePlot vertProf = new ProfilePlot(imagePlus, true);
            y = vertProf.getProfile();
            x = new double[ip.getHeight()];
            for (int i = 0; i < ip.getHeight(); ++i) {
                x[i] = i;
                if (!(y[i] > maxV)) continue;
                maxV = y[i];
            }
            if (c == 0) {
                vertPlot = new Plot("Horizontal Profile", "Distance", "Value", x, y);
                vertPlot.setColor(colors[c]);
                vertPlot.addPoints(x, y, 2);
            }
            vertPlot.setColor(colors[c]);
            vertPlot.addPoints(x, y, 2);
        }
        vertPlot.setColor(colors[0]);
        horzPlot.setColor(colors[0]);
        ImageProcessor hIp = horzPlot.getProcessor();
        ImageProcessor vIp = vertPlot.getProcessor();
        ColorProcessor disp = new ColorProcessor(hIp.getWidth(), hIp.getHeight() * 2);
        disp.insert(hIp, 0, 0);
        disp.insert(vIp, 0, hIp.getHeight());
        Image outR = this.mm.data().createImage((Object)disp.getChannel(1), hIp.getWidth(), hIp.getHeight() * 2, 1, 1, cb.channel(0).build(), this.mm.data().getMetadataBuilder().build());
        Image outG = this.mm.data().createImage((Object)disp.getChannel(2), hIp.getWidth(), hIp.getHeight() * 2, 1, 1, cb.channel(1).build(), this.mm.data().getMetadataBuilder().build());
        Image outB = this.mm.data().createImage((Object)disp.getChannel(3), hIp.getWidth(), hIp.getHeight() * 2, 1, 1, cb.channel(2).build(), this.mm.data().getMetadataBuilder().build());
        if (this.window == null) {
            ds = this.mm.data().createRewritableRAMDatastore();
            try {
                ds.putImage(outR);
                ds.putImage(outG);
                ds.putImage(outB);
            }
            catch (DatastoreRewriteException e) {
                this.mm.getLogManager().logError("Could not write to profile datastore");
            }
            catch (DatastoreFrozenException e) {
                this.mm.getLogManager().logError("Could not write to profile datastore");
            }
            this.window = this.mm.displays().createDisplay(ds);
            this.window.setDisplaySettings(this.window.getDisplaySettings().copy().channelColorMode(DisplaySettings.ColorMode.COMPOSITE).build());
        } else {
            ds = this.window.getDatastore();
            try {
                ds.putImage(outR);
                ds.putImage(outG);
                ds.putImage(outB);
            }
            catch (DatastoreRewriteException e) {
                this.mm.getLogManager().logError("Could not write to profile datastore");
            }
            catch (DatastoreFrozenException e) {
                this.mm.getLogManager().logError("Could not write to profile datastore");
            }
        }
    }

    void shutdown() {
        if (this.window != null) {
            this.window.forceClosed();
            this.window = null;
        }
    }
}

