/*
 * Decompiled with CFR 0.152.
 */
package com.cairn.multisplit_3;

import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.micromanager.Studio;
import org.micromanager.data.Coords;
import org.micromanager.data.Image;
import org.micromanager.data.Processor;
import org.micromanager.data.ProcessorContext;

public class MultiSplitProcessor
extends Processor {
    private Studio mm;
    private boolean initialised_;
    private ArrayList<Rectangle> channelData;
    private String mode_;

    MultiSplitProcessor(Studio MMStudio, boolean initialised, ArrayList<Rectangle> cData, String mode) {
        this.mm = MMStudio;
        this.initialised_ = initialised;
        this.channelData = cData;
        this.mode_ = mode;
    }

    public void processImage(Image image, ProcessorContext processorContext) {
        if (!this.initialised_) {
            processorContext.outputImage(image);
        } else if (this.mode_.equals("OptoSplit")) {
            ImageProcessor ip = this.mm.data().ij().createProcessor(image);
            Coords.CoordsBuilder cb = image.getCoords().copy();
            int chIdx = image.getCoords().getChannel();
            for (int channel = 0; channel < this.channelData.size(); ++channel) {
                cb.channel(chIdx * this.channelData.size() + channel);
                ip.setRoi(this.channelData.get(channel));
                Image out = this.mm.data().createImage(ip.crop().getPixels(), this.channelData.get((int)channel).width, this.channelData.get((int)channel).height, image.getBytesPerPixel(), image.getNumComponents(), cb.build(), image.getMetadata());
                processorContext.outputImage(out);
            }
        } else if (this.mode_.equals("MultiCam")) {
            ImageProcessor ip = this.mm.data().ij().createProcessor(image);
            Coords coords = image.getCoords();
            ip.setRoi(this.channelData.get(coords.getChannel()));
            Image out = this.mm.data().ij().createImage(ip.crop(), coords, image.getMetadata());
            processorContext.outputImage(out);
        }
    }
}

